/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.http.core.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.http.core.tests.OrderedTestSuite;

public class CreationTestCase
extends TestCase {
    private static IServer server;
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.http.core.tests.CreationTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz);
    }

    public void test00CreateServer() throws Exception {
        IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"com.ibm.etools.publishing.server.runtime");
        CreationTestCase.assertTrue((String)"V6 runtime type is not found", (runtimeType != null ? 1 : 0) != 0);
        IServerType serverType = ServerCore.findServerType((String)"org.eclipse.wst.server.http.server");
        CreationTestCase.assertTrue((serverType != null ? 1 : 0) != 0);
        IServerWorkingCopy serverWc = null;
        serverWc = serverType.createServer("HTTP Server", null, (IProgressMonitor)new NullProgressMonitor());
        server = serverWc.save(true, null);
        CreationTestCase.assertNotNull((Object)server);
    }

    public void test01DeleteServer() throws Exception {
        CreationTestCase.assertNotNull((String)"Cannot delete server since no server is avaiable.", (Object)server);
        server.delete();
    }

    public void test02CreateServer() throws Exception {
        IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"com.ibm.etools.publishing.static.server.runtime");
        CreationTestCase.assertTrue((String)"V6 runtime type is not found", (runtimeType != null ? 1 : 0) != 0);
        IServerType serverType = ServerCore.findServerType((String)"com.ibm.etools.publishing.static.server");
        CreationTestCase.assertTrue((String)"No Static server type has be defined.", (serverType != null ? 1 : 0) != 0);
        IServerWorkingCopy serverWc = null;
        serverWc = serverType.createServer("Static Server", null, (IProgressMonitor)new NullProgressMonitor());
        server = serverWc.save(true, null);
        CreationTestCase.assertNotNull((String)"The created server cannot be found.", (Object)server);
    }

    public void test03DeleteServer() throws Exception {
        CreationTestCase.assertNotNull((String)"Cannot delete server since no server is avaiable.", (Object)server);
        server.delete();
    }
}

