/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.ui.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetItem;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.eclipse.wst.common.snippets.tests.TestsPlugin;

public class SnippetUITests
extends TestCase {
    private SnippetDefinitions fCurrentDefinitions;
    static /* synthetic */ Class class$0;

    private IFile copyBundleEntryIntoWorkspace(String entryname, String fullPath) {
        IFile file = null;
        URL entry = TestsPlugin.getDefault().getBundle().getEntry(entryname);
        if (entry != null) {
            try {
                byte[] b = new byte[2048];
                InputStream input = entry.openStream();
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                int i = -1;
                while ((i = input.read(b)) > -1) {
                    output.write(b, 0, i);
                }
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fullPath));
                if (file != null) {
                    file.create((InputStream)new ByteArrayInputStream(output.toByteArray()), true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    private IProject createSimpleProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            SnippetUITests.assertTrue((boolean)project.exists());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    private IWorkbenchPage getActivePage() throws WorkbenchException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PlatformUI.getWorkbench().openWorkbenchWindow(null);
        }
        if ((page = window.getActivePage()) == null) {
            page = window.openPage(null);
        }
        return page;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fCurrentDefinitions = SnippetManager.getInstance().getDefinitions();
    }

    public void testInsertIntoActiveEditorNoVariables() throws Exception {
        IWorkbenchPage page = this.getActivePage();
        SnippetsView view = null;
        IViewPart o = page.showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        SnippetUITests.assertNotNull((Object)o);
        view = (SnippetsView)o;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SnippetUITests.assertEquals((String)"view part is wrong type", (String)clazz.getName(), (String)o.getClass().getName());
        ISnippetItem item = this.fCurrentDefinitions.getItem("org.eclipse.wst.common.snippets.tests.item0");
        SnippetUITests.assertNotNull((String)"test item 1 not found", (Object)item);
        this.createSimpleProject("testInsertIntoActiveEditor", null, null);
        IFile testFile = this.copyBundleEntryIntoWorkspace("testfiles/testInsertIntoActiveEditor.txt", "testInsertIntoActiveEditor/testInsertIntoActiveEditor.txt");
        IEditorDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(testFile.getName());
        SnippetUITests.assertTrue((String)"no default editor found", (descriptor != null ? 1 : 0) != 0);
        FileEditorInput editorInput = new FileEditorInput(testFile);
        IEditorPart openedEditor = this.getActivePage().openEditor((IEditorInput)editorInput, descriptor.getId(), true);
        SnippetUITests.assertTrue((String)"no default text editor found", (boolean)(openedEditor instanceof ITextEditor));
        view.setSelectedEntry((ISnippetsEntry)item);
        view.insert();
        IDocument document = ((ITextEditor)openedEditor).getDocumentProvider().getDocument((Object)editorInput);
        SnippetUITests.assertEquals((String)"resulting text does not match", (String)"sample content 0", (String)document.get());
        openedEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        PlatformUI.getWorkbench().saveAllEditors(false);
    }

    public void testOpenSnippetsView() throws CoreException {
        IWorkbenchPage page = this.getActivePage();
        IViewPart o = page.showView("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
        SnippetUITests.assertNotNull((Object)o);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.snippets.internal.ui.SnippetsView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SnippetUITests.assertEquals((String)"view part is wrong type", (String)clazz.getName(), (String)o.getClass().getName());
    }
}

