/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.adapter.internal.core;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.model.IURLProvider;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.IStaticWeb;
import org.eclipse.wst.server.preview.adapter.internal.core.Messages;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.wst.server.preview.adapter.internal.core.Trace;

public class PreviewServer
extends ServerDelegate
implements IURLProvider {
    public static final String ID = "org.eclipse.wst.server.preview.server";
    public static final String PROPERTY_PORT = "port";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    protected void initialize() {
    }

    public PreviewRuntime getPreviewRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.preview.adapter.internal.core.PreviewRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (PreviewRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    public URL getModuleRootURL(IModule module) {
        try {
            String base = "http://localhost";
            int port = this.getPort();
            URL url = null;
            url = port == 80 ? new URL(String.valueOf(base) + "/") : new URL(String.valueOf(base) + ":" + port + "/");
            String type = module.getModuleType().getId();
            if ("wst.web".equals(type)) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.server.core.util.IStaticWeb");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IStaticWeb staticWeb = (IStaticWeb)module.loadAdapter((Class)clazz, null);
                return new URL(url, staticWeb.getContextRoot());
            }
            return url;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not get root URL", e);
            return null;
        }
    }

    public IModule[] getChildModules(IModule[] module) {
        return new IModule[0];
    }

    public IModule[] getRootModules(IModule module) throws CoreException {
        return new IModule[]{module};
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove) {
        return new Status(0, "org.eclipse.wst.server.preview.adapter", 0, Messages.canModifyModules, null);
    }

    public ServerPort[] getServerPorts() {
        int port = this.getPort();
        ServerPort[] ports = new ServerPort[]{new ServerPort("http", Messages.httpPort, port, "http")};
        return ports;
    }

    public int getPort() {
        return this.getAttribute(PROPERTY_PORT, 8080);
    }

    public void setPort(int port) {
        this.setAttribute(PROPERTY_PORT, port);
    }

    public static IServer createPreviewServer(String serverName) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IRuntimeType runtimeType = ServerCore.findRuntimeType((String)"org.eclipse.wst.server.preview.runtime");
            IRuntimeWorkingCopy runtimeCopy = runtimeType.createRuntime("org.eclipse.wst.server.preview.runtime", (IProgressMonitor)monitor);
            IRuntime runtime = runtimeCopy.save(true, (IProgressMonitor)monitor);
            IServerType serverType = ServerCore.findServerType((String)ID);
            IServerWorkingCopy workingCopy = serverType.createServer(ID, null, runtime, (IProgressMonitor)monitor);
            workingCopy.setName(serverName);
            workingCopy.setHost("localhost");
            return workingCopy.save(true, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error creating server", e);
            return null;
        }
    }

    public static IServer findPreviewServer(String id) {
        IServer[] servers = ServerCore.getServers();
        int i = 0;
        while (i < servers.length) {
            if (servers[i].getId().equals(id)) {
                return servers[i];
            }
            ++i;
        }
        return null;
    }

    public void modifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) throws CoreException {
    }

    public String toString() {
        return "PreviewServer";
    }
}

