/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProjectUtility {
    public static IProject[] getAllProjects() {
        IProject[] projects = new IProject[]{};
        try {
            projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        catch (AssertionFailedException assertionFailedException) {}
        return projects;
    }

    public static void deleteAllProjects() throws Exception {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                IProject[] projects = ProjectUtility.getAllProjects();
                int i = 0;
                while (i < projects.length) {
                    IProject project = projects[i];
                    boolean success = false;
                    Exception lastException = null;
                    int j = 0;
                    while (j < 13 && !success) {
                        try {
                            if (project.exists()) {
                                project.delete(true, true, null);
                                ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                            }
                            success = true;
                        }
                        catch (Exception e) {
                            lastException = e;
                            if (project.exists()) {
                                try {
                                    project.close(null);
                                    project.open(null);
                                }
                                catch (Exception exception) {}
                            }
                            try {
                                Thread.sleep((int)Math.pow(2.0, j));
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        ++j;
                    }
                    if (!success) {
                        // empty if block
                    }
                    ++i;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException coreException) {}
    }
}

