/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jdtutility;

import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jpt.core.internal.jdtutility.FieldAttribute;
import org.eclipse.jpt.core.internal.jdtutility.MethodAttribute;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.tests.internal.projects.TestJavaProject;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotationTestCase
extends TestCase {
    protected TestJavaProject javaProject;
    protected static final String CR = System.getProperty("line.separator");
    protected static final String PROJECT_NAME = "AnnotationTestProject";
    protected static final String PACKAGE_NAME = "test";
    protected static final String TYPE_NAME = "AnnotationTestType";
    protected static final String FULLY_QUALIFIED_TYPE_NAME = "test.AnnotationTestType";
    protected static final String FILE_NAME = "AnnotationTestType.java";
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected AnnotationTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.javaProject = this.buildJavaProject(PROJECT_NAME, false);
    }

    protected TestJavaProject buildJavaProject(String projectName, boolean autoBuild) throws Exception {
        return new TestJavaProject(projectName, autoBuild);
    }

    protected void tearDown() throws Exception {
        this.javaProject.dispose();
        this.javaProject = null;
        super.tearDown();
    }

    protected void dumpSource() throws Exception {
        System.out.println("*** " + this.getName() + " ****");
        System.out.println(this.source());
        System.out.println();
    }

    protected IType createTestType() throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter());
    }

    protected IType createTestType(final String annotationImport, final String idFieldAnnotation) throws CoreException {
        return this.createTestType(new DefaultAnnotationWriter(){

            @Override
            public Iterator<String> imports() {
                return annotationImport == null ? EmptyIterator.instance() : new SingleElementIterator((Object)annotationImport);
            }

            @Override
            public void appendIdFieldAnnotationTo(StringBuffer sb) {
                sb.append(idFieldAnnotation);
            }
        });
    }

    protected IType createTestType(String idFieldAnnotation) throws CoreException {
        return this.createTestType(null, idFieldAnnotation);
    }

    protected IType createTestType(AnnotationWriter annotationWriter) throws CoreException {
        return this.javaProject.createType(PACKAGE_NAME, FILE_NAME, this.createSourceWriter(annotationWriter));
    }

    protected TestJavaProject.SourceWriter createSourceWriter(AnnotationWriter annotationWriter) {
        return new AnnotatedSourceWriter(annotationWriter);
    }

    protected void appendSourceTo(StringBuffer sb, AnnotationWriter annotationWriter) {
        sb.append(CR);
        Iterator<String> stream = annotationWriter.imports();
        while (stream.hasNext()) {
            sb.append("import ");
            sb.append(stream.next());
            sb.append(";");
            sb.append(CR);
        }
        annotationWriter.appendTypeAnnotationTo(sb);
        sb.append(CR);
        sb.append("public class ").append(TYPE_NAME).append(" {").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendIdFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private int id;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendNameFieldAnnotationTo(sb);
        sb.append(CR);
        sb.append("    private String name;").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public int getId() {").append(CR);
        sb.append("        return this.id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetIdMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setId(int id) {").append(CR);
        sb.append("        this.id = id;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendGetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public String getName() {").append(CR);
        sb.append("        return this.name;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("    ");
        annotationWriter.appendSetNameMethodAnnotationTo(sb);
        sb.append(CR);
        sb.append("    public void setTestField(String testField) {").append(CR);
        sb.append("        this.testField = testField;").append(CR);
        sb.append("    }").append(CR);
        sb.append(CR);
        sb.append("}").append(CR);
    }

    protected IType jdtType() throws JavaModelException {
        return this.javaProject.findType(FULLY_QUALIFIED_TYPE_NAME);
    }

    protected Type testType() throws JavaModelException {
        return new Type(this.jdtType());
    }

    protected FieldAttribute idField() throws JavaModelException {
        return this.fieldNamed("id");
    }

    protected FieldAttribute nameField() throws JavaModelException {
        return this.fieldNamed("name");
    }

    protected FieldAttribute fieldNamed(String fieldName) throws JavaModelException {
        return new FieldAttribute(this.jdtType().getField(fieldName));
    }

    protected MethodAttribute idGetMethod() throws JavaModelException {
        return this.methodNamed("getId");
    }

    protected MethodAttribute nameGetMethod() throws JavaModelException {
        return this.methodNamed("getName");
    }

    protected MethodAttribute methodNamed(String methodName) throws JavaModelException {
        return this.method(methodName, EMPTY_STRING_ARRAY);
    }

    protected MethodAttribute method(String methodName, String[] parameterTypeSignatures) throws JavaModelException {
        return new MethodAttribute(this.jdtType().getMethod(methodName, parameterTypeSignatures));
    }

    protected String source() throws JavaModelException {
        return this.jdtType().getOpenable().getBuffer().getContents();
    }

    protected void assertSourceContains(String s) throws JavaModelException {
        boolean found;
        String source = this.source();
        boolean bl = found = source.indexOf(s) > -1;
        if (!found) {
            String msg = "source does not contain the expected string: " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(source);
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected void assertSourceDoesNotContain(String s) throws JavaModelException {
        String source = this.source();
        int pos = source.indexOf(s);
        if (pos != -1) {
            String msg = "unexpected string in source (position: " + pos + "): " + s + " (see System console)";
            System.out.println("*** " + this.getName() + " ****");
            System.out.println(msg);
            System.out.println(source);
            System.out.println();
            AnnotationTestCase.fail((String)msg);
        }
    }

    protected MemberValuePair memberValuePair(NormalAnnotation annotation, String elementName) {
        for (MemberValuePair pair : this.values(annotation)) {
            if (!pair.getName().getFullyQualifiedName().equals(elementName)) continue;
            return pair;
        }
        return null;
    }

    protected List<MemberValuePair> values(NormalAnnotation na) {
        return na.values();
    }

    protected Expression valueInternal(MemberValuePair pair) {
        return pair == null ? null : pair.getValue();
    }

    protected Expression annotationElementValue(NormalAnnotation annotation, String elementName) {
        return this.valueInternal(this.memberValuePair(annotation, elementName));
    }

    protected Expression annotationElementValue(SingleMemberAnnotation annotation, String elementName) {
        return elementName.equals("value") ? annotation.getValue() : null;
    }

    protected Expression annotationElementValue(Annotation annotation, String elementName) {
        if (annotation.isNormalAnnotation()) {
            return this.annotationElementValue((NormalAnnotation)annotation, elementName);
        }
        if (annotation.isSingleMemberAnnotation()) {
            return this.annotationElementValue((SingleMemberAnnotation)annotation, elementName);
        }
        return null;
    }

    protected NumberLiteral newNumberLiteral(AST ast, int value) {
        return ast.newNumberLiteral(Integer.toString(value));
    }

    protected StringLiteral newStringLiteral(AST ast, String value) {
        StringLiteral stringLiteral = ast.newStringLiteral();
        stringLiteral.setLiteralValue(value);
        return stringLiteral;
    }

    protected MemberValuePair newMemberValuePair(AST ast, SimpleName name, Expression value) {
        MemberValuePair pair = ast.newMemberValuePair();
        pair.setName(name);
        pair.setValue(value);
        return pair;
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, Expression value) {
        return this.newMemberValuePair(ast, ast.newSimpleName(name), value);
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, String value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newStringLiteral(ast, value));
    }

    protected MemberValuePair newMemberValuePair(AST ast, String name, int value) {
        return this.newMemberValuePair(ast, name, (Expression)this.newNumberLiteral(ast, value));
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, MemberValuePair pair) {
        this.values(annotation).add(pair);
        return annotation;
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, int value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    protected NormalAnnotation addMemberValuePair(NormalAnnotation annotation, String name, String value) {
        return this.addMemberValuePair(annotation, this.newMemberValuePair(annotation.getAST(), name, value));
    }

    public class AnnotatedSourceWriter
    implements TestJavaProject.SourceWriter {
        private AnnotationWriter annotationWriter;

        public AnnotatedSourceWriter(AnnotationWriter annotationWriter) {
            this.annotationWriter = annotationWriter;
        }

        public void appendSourceTo(StringBuffer sb) {
            AnnotationTestCase.this.appendSourceTo(sb, this.annotationWriter);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface AnnotationWriter {
        public Iterator<String> imports();

        public void appendTypeAnnotationTo(StringBuffer var1);

        public void appendIdFieldAnnotationTo(StringBuffer var1);

        public void appendNameFieldAnnotationTo(StringBuffer var1);

        public void appendGetIdMethodAnnotationTo(StringBuffer var1);

        public void appendSetIdMethodAnnotationTo(StringBuffer var1);

        public void appendGetNameMethodAnnotationTo(StringBuffer var1);

        public void appendSetNameMethodAnnotationTo(StringBuffer var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnnotationWriterWrapper
    implements AnnotationWriter {
        private final AnnotationWriter aw;

        public AnnotationWriterWrapper(AnnotationWriter aw) {
            this.aw = aw;
        }

        @Override
        public Iterator<String> imports() {
            return this.aw.imports();
        }

        @Override
        public void appendTypeAnnotationTo(StringBuffer sb) {
            this.aw.appendTypeAnnotationTo(sb);
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuffer sb) {
            this.aw.appendIdFieldAnnotationTo(sb);
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuffer sb) {
            this.aw.appendNameFieldAnnotationTo(sb);
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuffer sb) {
            this.aw.appendGetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuffer sb) {
            this.aw.appendSetIdMethodAnnotationTo(sb);
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuffer sb) {
            this.aw.appendGetNameMethodAnnotationTo(sb);
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuffer sb) {
            this.aw.appendSetNameMethodAnnotationTo(sb);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultAnnotationWriter
    implements AnnotationWriter {
        @Override
        public Iterator<String> imports() {
            return EmptyIterator.instance();
        }

        @Override
        public void appendTypeAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendIdFieldAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendNameFieldAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendGetIdMethodAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendSetIdMethodAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendGetNameMethodAnnotationTo(StringBuffer sb) {
        }

        @Override
        public void appendSetNameMethodAnnotationTo(StringBuffer sb) {
        }
    }
}

