/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.jdtutility;

import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.jdtutility.Type;
import org.eclipse.jpt.core.tests.internal.jdtutility.AnnotationTestCase;

public class TypeTests
extends AnnotationTestCase {
    private IType jdtType;
    private Type testType;

    public TypeTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jdtType = this.createTestType();
        this.testType = new Type(this.jdtType);
    }

    protected void tearDown() throws Exception {
        this.testType = null;
        this.jdtType = null;
        super.tearDown();
    }

    public void testGetJdtMember() throws Exception {
        TypeTests.assertEquals((Object)this.jdtType, (Object)this.testType.getJdtMember());
    }

    public void testIsAbstract() throws Exception {
        TypeTests.assertFalse((boolean)this.testType.isAbstract());
    }

    public void testTopLevelDeclaringType() throws Exception {
        TypeTests.assertEquals((Object)this.testType, (Object)this.testType.topLevelDeclaringType());
    }

    public void testGetDeclaringType() throws Exception {
        TypeTests.assertNull((Object)this.testType.getDeclaringType());
    }

    public void testGetName() throws Exception {
        TypeTests.assertEquals((String)"AnnotationTestType", (String)this.testType.getName());
    }

    public void testTextRange() throws Exception {
        String source = this.jdtType.getOpenable().getBuffer().getContents();
        ITextRange textRange = this.testType.textRange();
        String body = source.substring(textRange.getOffset());
        TypeTests.assertTrue((boolean)body.startsWith("public class AnnotationTestType"));
    }
}

