/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;

public abstract class ResourceUtils {
    private static Logger _log = JSFUICommonPlugin.getLogger(ResourceUtils.class);
    protected ResourceBundle _resources;

    protected ResourceUtils() {
    }

    protected void setBundle(ResourceBundle resource, String bundleLocation) {
        this._resources = resource;
        if (this._resources == null) {
            _log.error("log.ResourceUtils", bundleLocation);
            JSFUICommonPlugin.getAlerts().error("pluginName", "log.ResourceUtils", (Object)bundleLocation);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this._resources;
    }

    public int getValue(String key, int defaultValue) {
        String stringValue = this.getString(key);
        if (stringValue != null) {
            try {
                return Integer.parseInt(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public long getValue(String key, long defaultValue) {
        String stringValue = this.getString(key);
        if (stringValue != null) {
            try {
                return Long.parseLong(stringValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public boolean isResource(String key) {
        return this.getString(key).equals("true");
    }

    public String getString(String key) {
        try {
            return this._resources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public String getString(String key, Object arg0) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public String getString(String key, Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public String getString(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public String getString(String key, Object[] args) {
        MessageFormat formatter = new MessageFormat(this.getString(key));
        return formatter.format(args);
    }

    public static void ensureClosed(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

