/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.designtime.internal.jsp.JSPModelProcessor;
import org.eclipse.jst.jsf.designtime.tests.DesignTimeTestsPlugin;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;

public class TestJSPModelProcessor
extends TestCase {
    private static final int NUM_JSPS = 25;
    private IFile _testJSP1;
    private List<IFile> _jsps;
    private JSFFacetedTestEnvironment _jsfFactedTestEnvironment;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)"www-proxy.us.oracle.com", (String)"80");
        WebProjectTestEnvironment projectTestEnvironment = new WebProjectTestEnvironment("TestJSPModelProcessor_" + this.getName());
        projectTestEnvironment.createProject(false);
        JDTTestEnvironment jdtTestEnvironment = new JDTTestEnvironment((ProjectTestEnvironment)projectTestEnvironment);
        TestFileResource input = new TestFileResource();
        input.load(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/bundle1.resources.data");
        jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(input.toBytes()), "bundles", "bundle1.properties");
        this._testJSP1 = (IFile)projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata1.jsp");
        this._jsps = new ArrayList<IFile>(25);
        int i = 0;
        while (i < 25) {
            this._jsps.add((IFile)projectTestEnvironment.loadResourceInWebRoot(DesignTimeTestsPlugin.getDefault().getBundle(), "/testdata/testdata1.jsp.data", "testdata_" + i + ".jsp"));
            ++i;
        }
        this._jsfFactedTestEnvironment = new JSFFacetedTestEnvironment(projectTestEnvironment);
        this._jsfFactedTestEnvironment.initialize("1.1");
    }

    protected void tearDown() throws Exception {
    }

    public void testGet() throws Exception {
        JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
        TestJSPModelProcessor.assertNotNull((Object)processor);
        TestJSPModelProcessor.assertFalse((boolean)processor.isDisposed());
    }

    public void testGetMapForScope() throws Exception {
        JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
        TestJSPModelProcessor.assertNotNull((Object)processor);
        Map scopeMap = processor.getMapForScope("request");
        TestJSPModelProcessor.assertTrue((boolean)scopeMap.isEmpty());
        scopeMap = processor.getMapForScope("session");
        TestJSPModelProcessor.assertTrue((boolean)scopeMap.isEmpty());
        scopeMap = processor.getMapForScope("application");
        TestJSPModelProcessor.assertTrue((boolean)scopeMap.isEmpty());
        scopeMap = processor.getMapForScope("none");
        TestJSPModelProcessor.assertTrue((boolean)scopeMap.isEmpty());
    }

    public void testRefreshAndGet() throws Exception {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getModelForRead(this._testJSP1);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
            TestJSPModelProcessor.assertNotNull((Object)processor);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            Map scopeMap = processor.getMapForScope("request");
            TestJSPModelProcessor.assertTrue((boolean)scopeMap.isEmpty());
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            processor.refresh(false);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            scopeMap = processor.getMapForScope("request");
            TestJSPModelProcessor.assertFalse((boolean)scopeMap.isEmpty());
            TestJSPModelProcessor.assertEquals((int)2, (int)scopeMap.size());
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testFileDeletion_RegressionBug199480() throws Exception {
        JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
        TestJSPModelProcessor.assertNotNull((Object)processor);
        TestJSPModelProcessor.assertFalse((boolean)processor.isDisposed());
        this._testJSP1.delete(true, null);
        TestJSPModelProcessor.assertTrue((boolean)processor.isDisposed());
    }

    public void testProjectClosure() throws Exception {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getModelForRead(this._testJSP1);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            TestJSPModelProcessor.assertNotNull((Object)processor);
            TestJSPModelProcessor.assertFalse((boolean)processor.isDisposed());
            processor.refresh(false);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            this._testJSP1.getProject().close(null);
            TestJSPModelProcessor.assertTrue((boolean)processor.isDisposed());
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testProjectDeletion() throws Exception {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = null;
        try {
            model = modelManager.getModelForRead(this._testJSP1);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            JSPModelProcessor processor = JSPModelProcessor.get((IFile)this._testJSP1);
            TestJSPModelProcessor.assertNotNull((Object)processor);
            TestJSPModelProcessor.assertFalse((boolean)processor.isDisposed());
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            processor.refresh(false);
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
            this._testJSP1.getProject().delete(true, null);
            TestJSPModelProcessor.assertTrue((boolean)processor.isDisposed());
            TestJSPModelProcessor.assertFalse((boolean)model.isShared());
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
    }

    public void testChangeRefresh() throws Exception {
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 19;
        nArray[2] = 10;
        nArray[3] = 16;
        nArray[4] = 14;
        nArray[5] = 4;
        nArray[6] = 13;
        nArray[7] = 11;
        nArray[8] = 24;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 23;
        nArray[12] = 20;
        nArray[13] = 15;
        nArray[14] = 17;
        nArray[15] = 9;
        nArray[16] = 1;
        nArray[17] = 5;
        nArray[18] = 22;
        nArray[19] = 12;
        nArray[20] = 21;
        nArray[21] = 8;
        nArray[22] = 18;
        nArray[24] = 7;
        int[] order = nArray;
        TestJSPModelProcessor.assertEquals((int)25, (int)order.length);
        int i = 0;
        while (i < order.length) {
            IFile file = this._jsps.get(order[i]);
            JSPModelProcessor processor = JSPModelProcessor.get((IFile)file);
            TestJSPModelProcessor.assertTrue((boolean)processor.isModelDirty());
            file.touch(null);
            TestJSPModelProcessor.assertFalse((boolean)processor.isModelDirty());
            file.delete(true, null);
            TestJSPModelProcessor.assertTrue((boolean)processor.isDisposed());
            ++i;
        }
    }

    public void testExplicitRefresh() throws Exception {
        int[] nArray = new int[25];
        nArray[0] = 6;
        nArray[1] = 19;
        nArray[2] = 10;
        nArray[3] = 16;
        nArray[4] = 14;
        nArray[5] = 4;
        nArray[6] = 13;
        nArray[7] = 11;
        nArray[8] = 24;
        nArray[9] = 2;
        nArray[10] = 3;
        nArray[11] = 23;
        nArray[12] = 20;
        nArray[13] = 15;
        nArray[14] = 17;
        nArray[15] = 9;
        nArray[16] = 1;
        nArray[17] = 5;
        nArray[18] = 22;
        nArray[19] = 12;
        nArray[20] = 21;
        nArray[21] = 8;
        nArray[22] = 18;
        nArray[24] = 7;
        int[] order = nArray;
        TestJSPModelProcessor.assertEquals((int)25, (int)order.length);
        int i = 0;
        while (i < order.length) {
            IFile file = this._jsps.get(order[i]);
            JSPModelProcessor processor = JSPModelProcessor.get((IFile)file);
            TestJSPModelProcessor.assertTrue((boolean)processor.isModelDirty());
            processor.refresh(false);
            TestJSPModelProcessor.assertFalse((boolean)processor.isModelDirty());
            file.delete(true, null);
            TestJSPModelProcessor.assertTrue((boolean)processor.isDisposed());
            ++i;
        }
    }

    public static void main(String[] args) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        Random random = new Random();
        while (set.size() < 25) {
            Integer value = Math.abs(random.nextInt()) % 25;
            if (set.contains(value)) continue;
            System.out.printf("%d,", value);
            set.add(value);
        }
    }
}

