/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.events.internal;

import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.IRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.IVersionExpr;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IPrimaryRuntimeChangedEvent;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.util.PluginUtil;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;

public final class LegacyEventHandlerAdapter
implements IFacetedProjectListener {
    private final IProjectFacet facet;
    private final IVersionExpr vexpr;
    private final String pluginId;
    private Object delegate;

    public LegacyEventHandlerAdapter(IProjectFacet facet, IVersionExpr vexpr, String delegatePluginId, String delegateClassName) {
        this.facet = facet;
        this.vexpr = vexpr;
        this.pluginId = delegatePluginId;
        this.delegate = delegateClassName;
    }

    public void handleEvent(IFacetedProjectEvent event) {
        if (event instanceof IProjectFacetActionEvent) {
            IDelegate delegate;
            IProjectFacetActionEvent ev = (IProjectFacetActionEvent)event;
            if (this.facet == ev.getProjectFacet() && this.vexpr.check(ev.getProjectFacetVersion()) && (delegate = this.getDelegate()) != null) {
                try {
                    delegate.execute(ev.getProject().getProject(), ev.getProjectFacetVersion(), ev.getActionConfig(), null);
                }
                catch (Exception e) {
                    FacetCorePlugin.log(e);
                }
            }
        } else if (event instanceof IPrimaryRuntimeChangedEvent) {
            IProjectFacetVersion fv;
            IPrimaryRuntimeChangedEvent ev = (IPrimaryRuntimeChangedEvent)event;
            IFacetedProject project = ev.getProject();
            if (project.hasProjectFacet(this.facet) && this.vexpr.check(fv = project.getInstalledVersion(this.facet))) {
                RuntimeChangedEvent legacyEvent = new RuntimeChangedEvent(ev.getOldPrimaryRuntime(), ev.getNewPrimaryRuntime());
                IDelegate delegate = this.getDelegate();
                if (delegate != null) {
                    try {
                        delegate.execute(ev.getProject().getProject(), fv, legacyEvent, null);
                    }
                    catch (Exception e) {
                        FacetCorePlugin.log(e);
                    }
                }
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private synchronized IDelegate getDelegate() {
        try {
            if (this.delegate instanceof String) {
                this.delegate = PluginUtil.instantiate(this.pluginId, (String)this.delegate, IDelegate.class);
            }
            return (IDelegate)this.delegate;
        }
        catch (Exception e) {
            FacetCorePlugin.log(e);
            return null;
        }
    }

    private static final class RuntimeChangedEvent
    implements IRuntimeChangedEvent {
        private final IRuntime oldRuntime;
        private final IRuntime newRuntime;

        public RuntimeChangedEvent(IRuntime oldRuntime, IRuntime newRuntime) {
            this.oldRuntime = oldRuntime;
            this.newRuntime = newRuntime;
        }

        public IRuntime getOldRuntime() {
            return this.oldRuntime;
        }

        public IRuntime getNewRuntime() {
            return this.newRuntime;
        }
    }
}

