/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.core.tests.j2ee;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.tests.j2ee.ModuleHelper;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.ServerUtil;

public class BinaryTestCase
extends TestCase {
    private static final String[] PROJECT_NAMES = new String[]{"PublishTestEAR", "PublishTestEJB", "test", "test2", "PublishTestWeb", "PublishTestWeb2", "PublishTestConnector", "PublishTestClient"};
    protected static IRuntime runtime;
    protected static IModule module;
    protected static IEnterpriseApplication ent;
    protected static IWebModule webModule;
    protected static IJ2EEModule j2eeModule;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void test001ImportModules() throws Exception {
        ModuleHelper.importProject("PublishTestBinary.zip", new String[]{PROJECT_NAMES[0]});
    }

    public void test002IncrementalBuild() throws Exception {
        ModuleHelper.buildIncremental();
    }

    public void test003NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ear").length, (int)1);
    }

    public void test004NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.web").length, (int)2);
    }

    public void test005NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.ejb").length, (int)1);
    }

    public void test006NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.utility").length, (int)0);
    }

    public void test007NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.appclient").length, (int)1);
    }

    public void test008NumModules() throws Exception {
        BinaryTestCase.assertEquals((int)ServerUtil.getModules((String)"jst.connector").length, (int)1);
    }

    public void test020EAR() throws Exception {
        module = ModuleHelper.getModule("jst.ear", "PublishTestEAR");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test021EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "META-INF/application.xml")) {
            BinaryTestCase.fail();
        }
    }

    public void test022EAR() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestUtil2.jar")) {
            BinaryTestCase.fail();
        }
    }

    public void test023EAR() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)4);
    }

    public void test024EAR() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)1);
    }

    public void test025EAR() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ear");
    }

    public void test026EAR() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.core.IEnterpriseApplication");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ent = (IEnterpriseApplication)module.loadAdapter((Class)clazz, null);
        BinaryTestCase.assertNotNull((Object)ent);
    }

    public void test027EAR() throws Exception {
        BinaryTestCase.assertEquals((int)ent.getResourceFolders().length, (int)1);
    }

    public void test028EAR() throws Exception {
        BinaryTestCase.assertEquals((int)ent.getModules().length, (int)5);
    }

    public void test029EAR() throws Exception {
        IModule[] modules = ent.getModules();
        int size = modules.length;
        ArrayList<String> list = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            list.add(modules[i].getName());
            ++i;
        }
        String[] s = new String[]{"PublishTestEJB.jar", "PublishTestWeb.war", "PublishTestWeb2.war", "PublishTestConnector.rar", "PublishTestClient.jar"};
        size = s.length;
        int i2 = 0;
        while (i2 < size) {
            if (!list.contains("lib/PublishTestEAR/EarContent/" + s[i2])) {
                BinaryTestCase.fail((String)("EAR does not contain " + s[i2]));
            }
            ++i2;
        }
    }

    public void test080EJB() throws Exception {
        module = ModuleHelper.getModule("jst.ejb", "lib/PublishTestEAR/EarContent/PublishTestEJB.jar");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test081EJB() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestEJB.jar")) {
            BinaryTestCase.fail();
        }
    }

    public void test084EJB() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)1);
    }

    public void test085EJB() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)0);
    }

    public void test086EJB() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.ejb");
    }

    public void test087EJB() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        BinaryTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test088EJB() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test089EJB() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)0);
    }

    public void test090EJB() throws Exception {
        BinaryTestCase.assertTrue((boolean)j2eeModule.isBinary());
    }

    public void test100Connector() throws Exception {
        module = ModuleHelper.getModule("jst.connector", "lib/PublishTestEAR/EarContent/PublishTestConnector.rar");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test101Connector() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestConnector.rar")) {
            BinaryTestCase.fail();
        }
    }

    public void test104Connector() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)1);
    }

    public void test105Connector() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)0);
    }

    public void test106Connector() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.connector");
    }

    public void test107Connector() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        BinaryTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test108Connector() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test109Connector() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)0);
    }

    public void test110Connector() throws Exception {
        BinaryTestCase.assertTrue((boolean)j2eeModule.isBinary());
    }

    public void test120Client() throws Exception {
        module = ModuleHelper.getModule("jst.appclient", "lib/PublishTestEAR/EarContent/PublishTestClient.jar");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test121Client() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestClient.jar")) {
            BinaryTestCase.fail();
        }
    }

    public void test125Client() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)1);
    }

    public void test126Client() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)0);
    }

    public void test127Client() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.appclient");
    }

    public void test128Client() throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IJ2EEModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        j2eeModule = (IJ2EEModule)module.loadAdapter((Class)clazz, null);
        BinaryTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test129Client() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test130Client() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)0);
    }

    public void test131Client() throws Exception {
        BinaryTestCase.assertTrue((boolean)j2eeModule.isBinary());
    }

    public void test140Web() throws Exception {
        module = ModuleHelper.getModule("jst.web", "lib/PublishTestEAR/EarContent/PublishTestWeb.war");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test141Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestWeb.war")) {
            BinaryTestCase.fail();
        }
    }

    public void test147Web() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)1);
    }

    public void test148Web() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)0);
    }

    public void test149Web() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test150Web() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        webModule = (IWebModule)module.loadAdapter((Class)clazz, null);
        j2eeModule = webModule;
        BinaryTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test151Web() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test152Web() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)0);
    }

    public void test153Web() throws Exception {
        BinaryTestCase.assertEquals((int)webModule.getModules().length, (int)0);
    }

    public void _test154Web() throws Exception {
        BinaryTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb");
    }

    public void test155Web() throws Exception {
        BinaryTestCase.assertTrue((boolean)webModule.isBinary());
    }

    public void test160Web() throws Exception {
        module = ModuleHelper.getModule("jst.web", "lib/PublishTestEAR/EarContent/PublishTestWeb2.war");
        BinaryTestCase.assertNotNull((Object)module);
    }

    public void test161Web() throws Exception {
        if (!ModuleHelper.fileExists(module, "PublishTestWeb2.war")) {
            BinaryTestCase.fail();
        }
    }

    public void test166Web() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFiles(module), (int)1);
    }

    public void test167Web() throws Exception {
        BinaryTestCase.assertEquals((int)ModuleHelper.countFolders(module), (int)0);
    }

    public void test168Web() throws Exception {
        BinaryTestCase.assertEquals((String)module.getModuleType().getId(), (String)"jst.web");
    }

    public void test169Web() throws Exception {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        webModule = (IWebModule)module.loadAdapter((Class)clazz, null);
        j2eeModule = webModule;
        BinaryTestCase.assertNotNull((Object)j2eeModule);
    }

    public void test170Web() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getResourceFolders().length, (int)1);
    }

    public void test171Web() throws Exception {
        BinaryTestCase.assertEquals((int)j2eeModule.getJavaOutputFolders().length, (int)0);
    }

    public void test172Web() throws Exception {
        BinaryTestCase.assertEquals((int)webModule.getModules().length, (int)0);
    }

    public void _test173Web() throws Exception {
        BinaryTestCase.assertEquals((String)webModule.getContextRoot(), (String)"PublishTestWeb2");
    }

    public void test174Client() throws Exception {
        BinaryTestCase.assertTrue((boolean)webModule.isBinary());
    }

    public void test199Cleanup() throws Exception {
        ModuleHelper.deleteProject(PROJECT_NAMES[0]);
    }
}

