/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests.unittest;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateModuleCommand;
import org.eclipse.jst.ws.tests.axis.tomcat.v50.WSWizardTomcat50Test;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.command.internal.env.eclipse.AccumulateStatusHandler;

public class TDJavaAxisTC50
extends WSWizardTomcat50Test {
    private final String WS_RUNTIMEID_AXIS = "org.eclipse.jst.ws.runtime.axis11";
    private String PROJECT_NAME = "TestTDProject";
    private IFile sourceFile_;

    public static Test suite() {
        return new TestSuite(TDJavaAxisTC50.class);
    }

    protected void createProjects() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        if (!webProject.exists()) {
            this.createWebModule(this.PROJECT_NAME, this.PROJECT_NAME, 14);
        }
    }

    private void createWebModule(String projectNm, String componentName, int j2eeVersion) {
        CreateModuleCommand cmc = new CreateModuleCommand();
        cmc.setJ2eeLevel(new Integer(j2eeVersion).toString());
        cmc.setModuleName(componentName);
        cmc.setModuleType(1);
        cmc.setProjectName(projectNm);
        cmc.setServerFactoryId("org.eclipse.jst.server.tomcat.50");
        cmc.setServerInstanceId(this.server_.getId());
        cmc.execute(null, null);
        System.out.println("Done creating Web Project, " + projectNm);
    }

    protected void installInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        IFolder destFolder = (IFolder)J2EEUtils.getWebContentContainer((IProject)webProject);
        JUnitUtils.copyTestData("TDJava", destFolder, this.env_, null);
        this.sourceFile_ = destFolder.getFile((IPath)new Path("Echo.wsdl"));
        JUnitUtils.syncBuildProject(webProject, this.env_, null);
    }

    protected void initJ2EEWSRuntimeServerDefaults() throws Exception {
        JUnitUtils.setWSRuntimeServer("org.eclipse.jst.ws.runtime.axis11", "org.eclipse.jst.server.tomcat.50");
    }

    protected void initInitialSelection() throws Exception {
        this.initialSelection_ = new StructuredSelection((Object)this.sourceFile_);
    }

    public void testTDJavaAxisTC50() throws Exception {
        IStatus[] status = JUnitUtils.launchCreationWizard("org.eclipse.jst.ws.creation.ui.wizard.serverwizard", "org.eclipse.core.resources.IFile", this.initialSelection_);
        this.verifyOutput(status);
    }

    private final void verifyOutput(IStatus[] status) throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        IFolder webContentFolder = (IFolder)J2EEUtils.getWebContentContainer((IProject)webProject);
        IFolder wsdlFolder = webContentFolder.getFolder("wsdl");
        TDJavaAxisTC50.assertTrue((boolean)wsdlFolder.exists());
        TDJavaAxisTC50.assertTrue((wsdlFolder.members().length > 0 ? 1 : 0) != 0);
        AccumulateStatusHandler statusHandler = new AccumulateStatusHandler(status);
        IStatus[] s = statusHandler.getErrorReports();
        if (s.length > 0) {
            int i = 0;
            while (i < s.length) {
                System.out.println("Error message for report #" + i + ": " + s[i].getMessage());
                ++i;
            }
        }
        TDJavaAxisTC50.assertTrue((s.length == 0 ? 1 : 0) != 0);
    }

    protected void deleteInputData() throws Exception {
        IProject webProject = ProjectUtilities.getProject((String)this.PROJECT_NAME);
        webProject.delete(true, true, null);
    }
}

