/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ejb.operations;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jst.j2ee.internal.ejb.project.operations.EJBComponentExportDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaFileTestingUtilities;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleExportOperationTest;

public class EJBExportOperationTest
extends ModuleExportOperationTest {
    public EJBExportOperationTest() {
        super("EJBExportOperationTests");
    }

    public EJBExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EJBExportOperationTest.class);
        return suite;
    }

    public void testEJBExport11_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("insaneEJB", null, null, null, JavaEEFacetConstants.EJB_11, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("fooEJB", null, null, null, JavaEEFacetConstants.EJB_2, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("barEJB", null, null, null, JavaEEFacetConstants.EJB_21, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("penEJB", null, null, null, JavaEEFacetConstants.EJB_3, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport11_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("testEJB", null, null, "testEAR", JavaEEFacetConstants.EJB_11, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("coolEJB", null, null, "booEAR", JavaEEFacetConstants.EJB_2, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("crazyEJB", null, null, "starEAR", JavaEEFacetConstants.EJB_21, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_Defaults() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport11_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("testEJB", null, null, "testEAR", JavaEEFacetConstants.EJB_11, false, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("coolEJB", null, null, "booEAR", JavaEEFacetConstants.EJB_2, false, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("crazyEJB", null, null, "starEAR", JavaEEFacetConstants.EJB_21, false, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_NoClient() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport11_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("fooBarEJB", "testEJBExportClient", null, "theirEAR", JavaEEFacetConstants.EJB_11, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("saneEJB", "coolEJBClient", null, "yourEAR", JavaEEFacetConstants.EJB_2, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("clipEJB", "crazyEJBClient", null, "ourEAR", JavaEEFacetConstants.EJB_21, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_ChangedEJBClientName() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("phoneEJB", "netoEJBClient", null, "waterEAR", JavaEEFacetConstants.EJB_3, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport11_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("cupEJB", null, "src", "openEAR", JavaEEFacetConstants.EJB_11, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("mouseEJB", null, "files", "closedEAR", JavaEEFacetConstants.EJB_2, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pcEJB", null, "stuff", "batEAR", JavaEEFacetConstants.EJB_21, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("keyEJB", null, "foo", "keyEAR", JavaEEFacetConstants.EJB_3, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport11A_ddToEAR_ChangedEJBClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("cupEJB", "superClient", "src", "openEAR", JavaEEFacetConstants.EJB_11, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport20_AddToEAR_ChangedEJBClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("mouseEJB", "dudeClient", "files", "closedEAR", JavaEEFacetConstants.EJB_2, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport21_AddToEAR_ChangedEJB_ClientNameChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pcEJB", "fireClient", "stuff", "batEAR", JavaEEFacetConstants.EJB_21, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEARChangedEJB_ClientName_ChangedClientSourceFolder() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("keyEJB", "wireClient", "foo", "keyEAR", JavaEEFacetConstants.EJB_3, false);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_Defaults_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("tigerEJB", null, null, null, JavaEEFacetConstants.EJB_3, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_Defaults_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("pandaEJB", null, null, "roundEAR", JavaEEFacetConstants.EJB_3, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_NoClient_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("netoEJB", null, null, "myEAR", JavaEEFacetConstants.EJB_3, false, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_ChangedEJBClientName_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("snakeEJB", "client", null, "groundEAR", JavaEEFacetConstants.EJB_3, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_ChangedClientSourceFolder_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("lionEJB", null, "barSrc", "pinEAR", JavaEEFacetConstants.EJB_3, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEJBExport30_AddToEAR_ChangedEJBClientName_ChangedClientSourceFolder_WithDD() throws Exception {
        IDataModel dm = EJBProjectCreationOperationTest.getEJBDataModel("monkeyEJB", "fooFooClient", "fooSrc", "outsideEAR", JavaEEFacetConstants.EJB_3, true);
        EJBExportOperationTest.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    protected String getModuleExtension() {
        return ".jar";
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return EJBExportOperationTest.getEJBExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }

    public static IDataModel getEJBExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        IDataModel exportModel = DataModelFactory.createDataModel((IDataModelProvider)new EJBComponentExportDataModelProvider());
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)projectName);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)destination);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", (Object)exportSource);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", (Object)overwriteExisting);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD", (Object)runBuild);
        return exportModel;
    }

    protected void addJavaFilesToProject(String projectName, String[] classNames, String prackageName) throws Exception {
        JavaFileTestingUtilities.addJavaFilesToEJB(projectName, classNames, prackageName);
    }

    protected void verifyJavaFilesExported(String archiveName, String[] classNames, String packageName, boolean withClassFiles, boolean withSource) throws Exception {
        JavaFileTestingUtilities.verifyJavaFilesInJAR(archiveName, classNames, packageName, withClassFiles, withSource);
    }
}

