/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.utility.operations;

import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilityImportOperationTest
extends ModuleImportOperationTest {
    private IArchive archive;

    public UtilityImportOperationTest() {
        super("UtilityImportOperationTests");
        this.archive = null;
    }

    public UtilityImportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(UtilityImportOperationTest.class);
        return suite;
    }

    public void testUtilityImport_Defaults() throws Exception {
        this.runImportTests_All("Utility_Defaults");
    }

    public void testUtilityImport_AddToExisitingEAR12() throws Exception {
        this.runImportTests_All("Utility_AddToExisitingEAR12");
    }

    public void testUtilityImport_AddToExisitingEAR13() throws Exception {
        this.runImportTests_All("Utility_AddToExisitingEAR13");
    }

    public void testUtilityImport_AddToExisitingEAR14() throws Exception {
        this.runImportTests_All("Utility_AddToExisitingEAR14");
    }

    public void testUtilityImport_AddToExisitingEAR5_WithDD() throws Exception {
        this.runImportTests_All("Utility_AddToExisitingEAR5_WithDD");
    }

    @Override
    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return EARExportOperationTest.getEARExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }

    @Override
    protected IDataModel getImportDataModel(String filePath, String projectName, IOverwriteHandler overwriteHandler, IDataModel creationModel, boolean closeArchiveOnDispose) throws Exception {
        IDataModel earImportModel = EARImportOperationTest.getEARImportDataModel(filePath, projectName, overwriteHandler, creationModel, closeArchiveOnDispose);
        this.archive = null;
        List utilityArchiveWrappers = Collections.EMPTY_LIST;
        this.archive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(filePath));
        ArchiveWrapper wrappedArchive = new ArchiveWrapper(this.archive);
        utilityArchiveWrappers = wrappedArchive.getEARUtilitiesAndWebLibs();
        if (utilityArchiveWrappers.size() > 0) {
            this.filterEJBClientJars(utilityArchiveWrappers, wrappedArchive);
        }
        earImportModel = EARImportOperationTest.setExtendedEARImportDataModelProperties(earImportModel, null, utilityArchiveWrappers, null, null, null, null);
        return earImportModel;
    }

    @Override
    protected void runImportTests_All(String testName) throws Exception {
        String archiveName = null;
        try {
            archiveName = String.valueOf(testName) + "_Defaults" + this.getModuleExtension();
            this.runAndVerifyImport_ExportedDefaults(archiveName);
            OperationTestCase.deleteAllProjects();
        }
        finally {
            if (this.archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        try {
            archiveName = String.valueOf(testName) + "_Source" + this.getModuleExtension();
            this.runAndVerifyImport_ExportedWithSource(archiveName);
            OperationTestCase.deleteAllProjects();
        }
        finally {
            if (this.archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        try {
            archiveName = String.valueOf(testName) + "_NoBuild" + this.getModuleExtension();
            this.runAndVerifyImport_ExportedWithDontRunBuild(archiveName);
            OperationTestCase.deleteAllProjects();
        }
        finally {
            if (this.archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
        try {
            archiveName = String.valueOf(testName) + "_Source_NoBuild" + this.getModuleExtension();
            this.runAndVerifyImport_ExportedWithSrouce_ExportedWithDontRunBuild(archiveName);
            OperationTestCase.deleteAllProjects();
        }
        finally {
            if (this.archive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(this.archive);
            }
        }
    }

    @Override
    protected String getModuleExtension() {
        return ".ear";
    }

    private void filterEJBClientJars(List<ArchiveWrapper> utilities, ArchiveWrapper earWrapper) {
        List modules = earWrapper.getEarModules();
        for (ArchiveWrapper module : modules) {
            ArchiveWrapper clientWrapper;
            if (!module.isEJBJarFile() || (clientWrapper = earWrapper.getEJBClientArchiveWrapper(module)) == null) continue;
            boolean removed = false;
            int i = 0;
            while (i < utilities.size() && !removed) {
                if (clientWrapper.getUnderLyingArchive() == utilities.get(i).getUnderLyingArchive()) {
                    utilities.remove(i);
                    removed = true;
                }
                ++i;
            }
        }
    }
}

