/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.internal;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.parsers.SAXParser;
import org.eclipse.wtp.releng.tools.component.IFileLocation;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.ILocationChildrenIterator;
import org.eclipse.wtp.releng.tools.component.internal.Bundle;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.FragmentXML;
import org.eclipse.wtp.releng.tools.component.internal.Library;
import org.eclipse.wtp.releng.tools.component.internal.PluginClasspath;
import org.eclipse.wtp.releng.tools.component.internal.PluginXML;
import org.eclipse.wtp.releng.tools.component.internal.ZipLocation;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractEmitter {
    private SAXParser saxParser;

    protected void copyImage(String imagePath, File dest) throws IOException {
        InputStream is = ClassLoader.getSystemResourceAsStream(imagePath);
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest));
        this.copy(is, bos);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copy(InputStream is, OutputStream os) throws IOException {
        block11: {
            if (is == null) return;
            if (os == null) return;
            try {
                b = new byte[2048];
                read = is.read(b);
                while (read != -1) {
                    os.write(b, 0, read);
                    read = is.read(b);
                }
            }
            catch (Throwable var6_5) {
                var5_6 = null;
                try {
                    os.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    is.close();
                    throw var6_5;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw var6_5;
            }
            {
                var5_7 = null;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 58->65)] { 
lbl28:
            // 1 sources

            os.close();
            break block11;
lbl30:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        is.close();
    }

    protected void harvestPlugins(File file, Map pluginId2Plugin, Map fragmentId2Fragment) {
        this.internalHarvestPlugins(file, pluginId2Plugin, fragmentId2Fragment);
        File[] children = file.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isFile() && children[i].getName().endsWith(".jar")) {
                ZipLocation zipLocation = new ZipLocation(children[i]);
                ILocationChildrenIterator it = zipLocation.childIterator();
                boolean done = false;
                ILocation childLoc = it.next();
                while (!done && childLoc != null) {
                    String childName = childLoc.getName();
                    if ("plugin.xml".equalsIgnoreCase(childName)) {
                        PluginXML pluginXML = this.getSingleJarPlugin(childLoc);
                        String pluginName = pluginXML.getName();
                        if (pluginName != null && !pluginId2Plugin.containsKey(pluginName)) {
                            pluginXML.addLibrary(new Library(zipLocation));
                            pluginId2Plugin.put(pluginName, pluginXML);
                            done = true;
                        }
                    } else if (childName.indexOf("MANIFEST.MF") != -1) {
                        try {
                            Manifest manifest = new Manifest(childLoc.getInputStream());
                            Attributes attrs = manifest.getMainAttributes();
                            String bundleNameAttr = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
                            if (bundleNameAttr != null) {
                                String bundleName = new StringTokenizer(bundleNameAttr, "; ").nextToken();
                                Bundle bundle = new Bundle(childLoc);
                                bundle.setName(bundleName);
                                bundle.setVersion(attrs.getValue(new Attributes.Name("Bundle-Version")));
                                bundle.addLibrary(new Library(zipLocation));
                                pluginId2Plugin.put(bundleName, bundle);
                                done = true;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    childLoc = it.next();
                }
            }
            ++i;
        }
    }

    private void internalHarvestPlugins(File file, Map pluginId2Plugin, Map fragmentId2Fragment) {
        PluginClasspath plugin;
        String pluginName;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.internalHarvestPlugins(files[i], pluginId2Plugin, fragmentId2Fragment);
                ++i;
            }
        } else if ("plugin.xml".equalsIgnoreCase(file.getName())) {
            PluginXML plugin2 = this.getPlugin(new FileLocation(new FileLocation(file.getParentFile()), file.getName()));
            String pluginName2 = plugin2.getName();
            if (pluginName2 != null && !pluginId2Plugin.containsKey(pluginName2)) {
                pluginId2Plugin.put(pluginName2, plugin2);
            }
        } else if ("fragment.xml".equalsIgnoreCase(file.getName())) {
            FragmentXML fragment = this.getFragment(new FileLocation(new FileLocation(file.getParentFile()), file.getName()));
            String fragmentName = fragment.getFragmentName();
            if (fragmentName != null) {
                fragmentId2Fragment.put(fragmentName, fragment);
            }
        } else if ("MANIFEST.MF".equalsIgnoreCase(file.getName())) {
            Bundle plugin3 = this.getBundle(new FileLocation(new FileLocation(file.getParentFile()), file.getName()));
            String pluginName3 = plugin3.getName();
            if (pluginName3 != null) {
                pluginId2Plugin.put(pluginName3, plugin3);
            }
        } else if (".classpath".equalsIgnoreCase(file.getName()) && (pluginName = (plugin = this.getPluginClasspath(new FileLocation(new FileLocation(file.getParentFile()), file.getName()), true)).getName()) != null) {
            pluginId2Plugin.put(pluginName, plugin);
        }
    }

    public PluginXML getSingleJarPlugin(ILocation location) {
        SingleJaredPluginHandler handler = new SingleJaredPluginHandler(location);
        try {
            this.parse(location, handler);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return handler.getPlugin();
    }

    public PluginXML getPlugin(ILocation location) {
        PluginHandler handler = new PluginHandler(location);
        try {
            this.parse(location, handler);
        }
        catch (IOException iOException) {
            System.err.println("Could not read " + location.getName() + ", skipping");
        }
        return handler.getPlugin();
    }

    public FragmentXML getFragment(ILocation location) {
        FragmentHandler handler = new FragmentHandler(location);
        try {
            this.parse(location, handler);
        }
        catch (IOException iOException) {
            System.err.println("Could not read " + location.getName() + ", skipping");
        }
        return handler.getFragment();
    }

    public Bundle getBundle(ILocation location) {
        Bundle bundle = new Bundle(location);
        try {
            Manifest manifest = new Manifest(location.getInputStream());
            Attributes attrs = manifest.getMainAttributes();
            String bundleName = attrs.getValue(new Attributes.Name("Bundle-SymbolicName"));
            if (bundleName != null) {
                bundle.setName(new StringTokenizer(bundleName, "; ").nextToken());
            }
            bundle.setVersion(attrs.getValue(new Attributes.Name("Bundle-Version")));
            String classpathString = attrs.getValue(new Attributes.Name("Bundle-ClassPath"));
            if (classpathString != null && classpathString.length() > 0) {
                StringTokenizer classpath = new StringTokenizer(classpathString, ",");
                while (classpath.hasMoreTokens()) {
                    bundle.addLibrary(classpath.nextToken());
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return bundle;
    }

    public PluginClasspath getPluginClasspath(IFileLocation fileLocation, boolean validate) {
        return new PluginClasspath(fileLocation, validate);
    }

    /*
     * Exception decompiling
     */
    protected void parse(ILocation location, DefaultHandler handler) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 111->115)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void linkPluginsAndFragments(Map pluginId2Plugin, Map fragmentId2Fragment) {
        Iterator it = fragmentId2Fragment.values().iterator();
        while (it.hasNext()) {
            FragmentXML fragment = (FragmentXML)it.next();
            fragment.link(pluginId2Plugin);
        }
    }

    protected void harvestComponents(File file, Map compLoc2CompXML) {
        this.harvestComponents(file, compLoc2CompXML, new ArrayList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void harvestComponents(File file, Map compLoc2CompXML, List addedComps) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                this.harvestComponents(files[i], compLoc2CompXML, addedComps);
                ++i;
            }
            return;
        } else {
            if (!"component.xml".equalsIgnoreCase(file.getName())) return;
            ComponentXML compXML = new ComponentXML();
            FileLocation location = new FileLocation(file);
            compXML.setLocation(location);
            try {
                compXML.load();
                String compName = compXML.getName();
                if (addedComps.contains(compName)) return;
                compLoc2CompXML.put(location.getAbsolutePath(), compXML);
                addedComps.add(compName);
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String decodeClassName(String className) {
        return className.replace('/', '.');
    }

    protected String addTrailingSeperator(String s) {
        if (s != null && !s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    private class FragmentHandler
    extends DefaultHandler {
        private FragmentXML fragment;

        public FragmentHandler(ILocation location) {
            this.fragment = new FragmentXML(location);
        }

        public FragmentXML getFragment() {
            return this.fragment;
        }

        public void startElement(String uri, String elementName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (elementName.equals("fragment") || qName.equals("fragment")) {
                this.fragment.setFragmentName(attributes.getValue("id"));
                this.fragment.setVersion(attributes.getValue("version"));
                this.fragment.setName(attributes.getValue("plugin-id"));
                this.fragment.setVersion(attributes.getValue("plugin-version"));
                return;
            }
            if (elementName.equals("library") || qName.equals("library")) {
                this.fragment.addLibrary(attributes.getValue("name"));
                return;
            }
        }
    }

    private class PluginHandler
    extends SingleJaredPluginHandler {
        public PluginHandler(ILocation location) {
            super(location);
        }

        public void startElement(String uri, String elementName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            super.startElement(uri, elementName, qName, attributes);
            if (elementName.equals("library") || qName.equals("library")) {
                this.plugin.addLibrary(attributes.getValue("name"));
            }
        }
    }

    private class SingleJaredPluginHandler
    extends DefaultHandler {
        protected PluginXML plugin;

        public SingleJaredPluginHandler(ILocation location) {
            this.plugin = new PluginXML(location);
        }

        public PluginXML getPlugin() {
            return this.plugin;
        }

        public void startElement(String uri, String elementName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            if (elementName.equals("plugin") || qName.equals("plugin")) {
                this.plugin.setName(attributes.getValue("id"));
                this.plugin.setVersion(attributes.getValue("version"));
                return;
            }
        }
    }
}

