/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.tests.contentmodels;

import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.jst.jsp.core.internal.contentmodel.JSPCMDocumentFactory;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;

public class TestFixedCMDocuments
extends TestCase {
    public TestFixedCMDocuments(String name) {
        super(name);
    }

    public TestFixedCMDocuments() {
    }

    public static Test suite() {
        return new TestFixedCMDocuments();
    }

    public void testCHTMLdocument() {
        this.checkDocument("CHTML");
    }

    private void checkDocument(Object documentKey) {
        CMDocument document = JSPCMDocumentFactory.getCMDocument((String)documentKey.toString());
        TestFixedCMDocuments.assertNotNull((String)("missing doc:" + documentKey.toString()), (Object)document);
        CMNamedNodeMap elements = document.getElements();
        int i = 0;
        while (i < elements.getLength()) {
            CMNode item = elements.item(i);
            this.verifyElementDeclarationHasName(item);
            ++i;
        }
    }

    private void verifyElementDeclarationHasName(CMNode item) {
        TestFixedCMDocuments.assertTrue((item.getNodeType() == 5 ? 1 : 0) != 0);
        TestFixedCMDocuments.assertNotNull((String)"no name on an element declaration", (Object)item.getNodeName());
        CMNamedNodeMap attrs = ((CMElementDeclaration)item).getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            CMNode attr = attrs.item(i);
            this.verifyAttributeDeclaration((CMElementDeclaration)item, attr);
            ++i;
        }
    }

    private void verifyAttributeDeclaration(CMElementDeclaration elemDecl, CMNode attr) {
        TestFixedCMDocuments.assertTrue((attr.getNodeType() == 2 ? 1 : 0) != 0);
        TestFixedCMDocuments.assertNotNull((String)"no name on an attribute declaration", (Object)attr.getNodeName());
        CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)attr;
        TestFixedCMDocuments.assertNotNull((String)("no attribute 'type' on an attribute declaration " + elemDecl.getNodeName() + "/" + attr.getNodeName()), (Object)attrDecl.getAttrType());
    }

    public void testHTML4document() {
        this.checkDocument("HTML");
    }

    public void testJSP11document() {
        this.checkDocument("JSP11");
    }

    public void testJSP12document() {
        this.checkDocument("JSP12");
    }

    public void testJSP20document() {
        this.checkDocument("JSP20");
    }

    public void testTag20document() {
        this.checkDocument("JSP20.TAG");
    }
}

