/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFEditingTest;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class AppClientEMFEditTest
extends GeneralEMFEditingTest {
    EARFile earFile;
    ApplicationClientFile appClientFile;

    public AppClientEMFEditTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchivePackage.eINSTANCE.getCommonarchiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.AppClientEMFEditTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new AppClientEMFEditTest("testApplicationClientEdit"));
        return suite;
    }

    public void testApplicationClientEdit() throws Exception {
        this.getAppClient();
        AppClientEMFEditTest.assertEquals((String)"1.3", (String)this.appClientFile.getDeploymentDescriptor().getVersion());
        ApplicationClientResource DD = (ApplicationClientResource)this.appClientFile.getDeploymentDescriptorResource();
        this.setVersion(1);
        this.setModuleType(1);
        this.editRoot(DD.getRootObject());
        String curDir = AutomatedBVT.baseDirectory;
        String out = String.valueOf(curDir) + "testOutput/EMFModelCreationTests/EditAppEAR";
        this.appClientFile.extractTo(out, 126);
        this.appClientFile.close();
        String cfr_ignored_0 = String.valueOf(curDir) + "EMFTests/application-client.xml";
        String cfr_ignored_1 = String.valueOf(curDir) + out + "/AppClientfoo/META-INF/application-client.xml";
        AppClientEMFEditTest.setIgnoreAtt(this.ignorableAttributes());
    }

    public void getAppClient() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "loose_module_workspace/LooseEARApp/fooAPP/";
        this.appClientFile = this.getArchiveFactory().openApplicationClientFile(in);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }
}

