/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.jst.j2ee.application.ApplicationFactory;
import org.eclipse.jst.j2ee.application.ApplicationPackage;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchiveFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.webapplication.WebapplicationFactory;
import org.eclipse.jst.j2ee.webapplication.WebapplicationPackage;

public class AppClientEMFTest
extends GeneralEMFPopulationTest {
    EARFile earFile;
    protected ApplicationClientFile appClientFile;
    EARFile earFile14;
    ApplicationClientFile appClientFile14;

    public AppClientEMFTest(String name) {
        super(name);
    }

    public CommonarchiveFactory getArchiveFactory() {
        return CommonarchiveFactoryImpl.getActiveFactory();
    }

    public EjbFactory getEjbFactory() {
        return EjbPackage.eINSTANCE.getEjbFactory();
    }

    public ApplicationFactory getApplicationFactory() {
        return ApplicationPackage.eINSTANCE.getApplicationFactory();
    }

    public WebapplicationFactory getWebAppFactory() {
        return WebapplicationPackage.eINSTANCE.getWebapplicationFactory();
    }

    public static void main(String[] args) {
        String[] className = new String[]{"com.ibm.etools.archive.test.AppClientEMFTest", "-noloading"};
        TestRunner.main((String[])className);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new AppClientEMFTest("testApplicationClientPopulation"));
        return suite;
    }

    public void testApplicationClientPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createAppClient();
        ApplicationClientResource DD = (ApplicationClientResource)this.appClientFile.getDeploymentDescriptorResource();
        DD.setVersionID(13);
        this.setVersion(1);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestAppEAR";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        String curDir = AutomatedBVT.baseDirectory;
        String exampleDeploymentDesURI = String.valueOf(curDir) + "EMFTestNoID/application-client.xml";
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestAppEAR/fooAPP/META-INF/application-client.xml";
        AppClientEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, exampleDeploymentDesURI, null);
    }

    public void test14ApplicationClientPopulation() throws Exception {
        EMFAttributeFeatureGenerator.reset();
        this.createEAR();
        this.createAppClient();
        ApplicationClientResource DD = (ApplicationClientResource)this.appClientFile.getDeploymentDescriptorResource();
        DD.setVersionID(14);
        this.setVersion(2);
        this.setModuleType(1);
        this.populateRoot(DD.getRootObject());
        String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestAppEAR14";
        this.earFile.extractTo(out, 126);
        this.earFile.close();
        this.getApp14Client();
        AppClientEMFTest.assertEquals((String)"1.4", (String)this.appClientFile14.getDeploymentDescriptor().getVersion());
        out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestAppEAR14_2";
        this.appClientFile14.extractTo(out, 126);
        this.appClientFile14.close();
        String curDir = AutomatedBVT.baseDirectory;
        String curDeploymentDesURI = String.valueOf(curDir) + "testOutput/TestAppEAR14/fooAPP/META-INF/application-client.xml";
        String secondDeploymentDesURI = String.valueOf(out) + "/META-INF/application-client.xml";
        AppClientEMFTest.setIgnoreAtt(this.ignorableAttributes());
        this.compareContentsIgnoreWhitespace(curDeploymentDesURI, secondDeploymentDesURI, null);
    }

    public void createAppClient() throws DuplicateObjectException {
        this.appClientFile = this.getArchiveFactory().createApplicationClientFileInitialized("fooAPP");
        this.appClientFile = (ApplicationClientFile)this.earFile.addCopy((ModuleFile)this.appClientFile);
        this.appClientFile.getDeploymentDescriptor().setDisplayName("fooAPP");
        AppClientEMFTest.assertTrue((this.appClientFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void createEAR() {
        String earName = "Test.ear";
        this.earFile = this.getArchiveFactory().createEARFileInitialized(earName);
        AppClientEMFTest.assertTrue((this.earFile.getDeploymentDescriptor() != null ? 1 : 0) != 0);
    }

    public void getApp14Client() throws DuplicateObjectException, OpenFailureException {
        String in = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/TestAppEAR14/fooAPP";
        this.appClientFile14 = this.getArchiveFactory().openApplicationClientFile(in);
    }

    public HashSet ignorableAttributes() {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        return set;
    }
}

