/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.workbenchimpl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.sample.parser.APropertyFile;
import org.eclipse.jst.validation.sample.parser.PropertyLine;
import org.eclipse.jst.validation.sample.workbenchimpl.PropertiesValidatorPlugin;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;

public class PropertiesHelper
extends WorkbenchContext {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public PropertiesHelper() {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        this.registerModel("get a LineInputReader for a .properties file", "loadLineNumberReader", classArray);
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.LineNumberReader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        this.registerModel("relase (close) the LineInputReader", "releaseLineNumberReader", classArray2);
        this.registerModel("return an IFileDelta[] of all of the .properties files in the project", "loadAllPropertiesFiles");
        this.registerModel("get the MsgLogger needed to log messages. This MsgLogger must never be null.", "getMsgLogger");
        Class[] classArray3 = new Class[1];
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.wst.validation.internal.core.IFileDelta;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz3;
        this.registerModel("get only the .properties files that are in src dir; filter out the .properties files that are in bin dir (i.e., don't validate the same file twice", "filter", classArray3);
    }

    public String getTargetObjectName(Object object) {
        return null;
    }

    public IResource getResource(Object object) {
        IFile file = null;
        if (object instanceof PropertyLine) {
            PropertyLine line = (PropertyLine)object;
            APropertyFile pFile = line.getFile();
            String fileName = pFile.getQualifiedFileName();
            file = this.getFile(fileName);
        } else if (object instanceof APropertyFile) {
            APropertyFile pFile = (APropertyFile)object;
            String fileName = pFile.getQualifiedFileName();
            file = this.getFile(fileName);
        }
        if (file == null || !file.exists()) {
            return super.getResource(object);
        }
        return file;
    }

    public IFileDelta[] loadAllPropertiesFiles() {
        HashSet files;
        block2: {
            IProject project = this.getProject();
            files = new HashSet();
            IResourceVisitor visitor = new IResourceVisitor(){

                public boolean visit(IResource res) throws CoreException {
                    if (!res.isAccessible()) {
                        return false;
                    }
                    if (PropertiesHelper.this.isSrcFile(res)) {
                        WorkbenchFileDelta newFileDelta = new WorkbenchFileDelta(res.getFullPath().toString(), 2, res);
                        files.add(newFileDelta);
                    }
                    return true;
                }
            };
            try {
                project.accept(visitor, 2, true);
            }
            catch (CoreException e) {
                Logger logger = this.getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                logger.write((Throwable)e);
            }
        }
        IFileDelta[] result = new IFileDelta[files.size()];
        files.toArray(result);
        return result;
    }

    public IFile getFile(String fileName) {
        IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(fileName);
        return file;
    }

    public LineNumberReader loadLineNumberReader(String fileName) {
        try {
            IFile file = this.getFile(fileName);
            InputStream in = file.getContents();
            InputStreamReader reader = new InputStreamReader(in);
            LineNumberReader lineInput = new LineNumberReader(reader);
            return lineInput;
        }
        catch (CoreException exc) {
            Logger logger = this.getMsgLogger();
            if (logger.isLoggingLevel(Level.SEVERE)) {
                logger.write((Throwable)exc);
            }
            return null;
        }
    }

    public LineNumberReader releaseLineNumberReader(LineNumberReader reader) {
        block3: {
            if (reader == null) {
                return null;
            }
            try {
                reader.close();
            }
            catch (IOException exc) {
                Logger logger = this.getMsgLogger();
                if (!logger.isLoggingLevel(Level.SEVERE)) break block3;
                logger.write((Throwable)exc);
            }
        }
        return null;
    }

    public Logger getMsgLogger() {
        return PropertiesValidatorPlugin.getPlugin().getMsgLogger();
    }

    boolean isSrcFile(IResource res) {
        if (res == null) {
            return false;
        }
        if (!(res instanceof IFile)) {
            return false;
        }
        if (!"properties".equals(res.getFileExtension())) {
            return false;
        }
        return !res.isDerived();
    }

    public IFileDelta[] filter(IFileDelta[] changedFiles) {
        IFileDelta[] temp = new IFileDelta[changedFiles.length];
        int count = 0;
        int i = 0;
        while (i < changedFiles.length) {
            IFileDelta fd = changedFiles[i];
            IResource resource = ((WorkbenchFileDelta)fd).getResource();
            if (this.isSrcFile(resource)) {
                temp[count++] = fd;
            }
            ++i;
        }
        if (count == changedFiles.length) {
            return changedFiles;
        }
        IFileDelta[] result = new IFileDelta[count];
        System.arraycopy(temp, 0, result, 0, count);
        return result;
    }
}

