/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tests.resource;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jst.jsf.common.internal.ITestTracker;
import org.eclipse.jst.jsf.common.internal.resource.IResourceLifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.LifecycleListener;
import org.eclipse.jst.jsf.common.internal.resource.ResourceLifecycleEvent;
import org.eclipse.jst.jsf.core.tests.TestsPlugin;
import org.eclipse.jst.jsf.core.tests.resource.MockListener;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.PerfTracker;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;

public class LifecycleStressTest
extends TestCase {
    private static final int NUM_PROJECTS = 50;
    private static final int NUM_FILES = 100;
    private Map<IProject, List<IFile>> _resources;
    private LifecycleListener _listener;

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        this._resources = new HashMap<IProject, List<IFile>>();
        this._listener = new LifecycleListener();
        int i = 0;
        while (i < 50) {
            WebProjectTestEnvironment webProjectTestEnv = new WebProjectTestEnvironment(this.getProjectName(this.getName(), i));
            webProjectTestEnv.createProject(false);
            LifecycleStressTest.assertNotNull((Object)webProjectTestEnv);
            LifecycleStressTest.assertNotNull((Object)webProjectTestEnv.getTestProject());
            LifecycleStressTest.assertTrue((boolean)webProjectTestEnv.getTestProject().isAccessible());
            ArrayList<IFile> list = new ArrayList<IFile>();
            int j = 0;
            while (j < 100) {
                IFile file = (IFile)webProjectTestEnv.loadResourceInWebRoot(TestsPlugin.getDefault().getBundle(), "/testfiles/jsps/testdata1.jsp.data", "/testdata_" + j + ".jsp");
                list.add(file);
                this._listener.addResource((IResource)file);
                ++j;
            }
            this._resources.put(webProjectTestEnv.getTestProject(), list);
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        for (IProject project : this._resources.keySet()) {
            project.delete(true, null);
        }
        this._resources.clear();
    }

    public void testChanges() throws Exception {
        int[] projectIdx = new int[1000];
        int[] fileIdx = new int[1000];
        Random random = new Random();
        int i = 0;
        while (i < 1000) {
            projectIdx[i] = random.nextInt(50);
            fileIdx[i] = random.nextInt(100);
            ++i;
        }
        this.traceIntArray(System.out, "Project sequence: ", projectIdx);
        this.traceIntArray(System.out, "File sequence: ", fileIdx);
        LifecycleTestTracker tracker = new LifecycleTestTracker(1000);
        this._listener.setTestTracker((ITestTracker)tracker);
        int i2 = 0;
        while (i2 < 1000) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName(this.getName(), projectIdx[i2]));
            List<IFile> fileList = this._resources.get(project);
            MockListener listener = new MockListener();
            this._listener.addListener((IResourceLifecycleListener)listener);
            fileList.get(fileIdx[i2]).touch(null);
            listener.assertAcceptedEvent((IResource)fileList.get(fileIdx[i2]), ResourceLifecycleEvent.EventType.RESOURCE_CHANGED, ResourceLifecycleEvent.ReasonType.RESOURCE_CHANGED_CONTENTS);
            this._listener.removeListener((IResourceLifecycleListener)listener);
            ++i2;
        }
        tracker.report(System.out);
    }

    private String getProjectName(String testName, int idx) {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "_" + testName + idx;
    }

    private void traceIntArray(PrintStream stream, String prefix, int[] intArray) {
        stream.print(prefix);
        int i = 0;
        while (i < intArray.length - 1) {
            stream.print(String.valueOf(intArray[i]) + ",");
            ++i;
        }
        stream.print(intArray[intArray.length - 1]);
        stream.print("\n");
    }

    private static class LifecycleTestTracker
    implements ITestTracker {
        private final PerfTracker _resourceChangedTimes;
        private long _lastResourceChangedId;
        private long _curResourceChangedTime;

        public LifecycleTestTracker(int numberOfDataPoints) {
            this._resourceChangedTimes = new PerfTracker("ResourceChanged", numberOfDataPoints + 100);
        }

        public void fireEvent(ITestTracker.Event event, long seqId, String eventLabel) {
            long curTime = System.nanoTime();
            switch (event) {
                case START_TRACKING: {
                    if ("trackMethod_resourceChanged".equals(eventLabel)) {
                        this._curResourceChangedTime = curTime;
                        this._lastResourceChangedId = seqId;
                        break;
                    }
                    "testFindMember".equals(eventLabel);
                    break;
                }
                case STOP_TRACKING: {
                    if ("trackMethod_resourceChanged".equals(eventLabel)) {
                        LifecycleStressTest.assertEquals((long)this._lastResourceChangedId, (long)seqId);
                        this._resourceChangedTimes.recordTime(curTime - this._curResourceChangedTime);
                        break;
                    }
                    "testFindMember".equals(eventLabel);
                }
            }
        }

        public void report(PrintStream stream) {
            this._resourceChangedTimes.printReport(System.out);
        }
    }
}

