/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test;

import java.util.logging.Level;
import org.eclipse.core.boot.IPlatformRunnable;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.validation.test.BVTValidationException;
import org.eclipse.jst.validation.test.BVTValidationPlugin;
import org.eclipse.jst.validation.test.ConsoleBuffer;
import org.eclipse.jst.validation.test.ConsoleProgressMonitor;
import org.eclipse.jst.validation.test.internal.util.BVTRunner;
import org.eclipse.jst.validation.test.internal.util.BVTValidationUtility;

public class BVTValidationBatch
implements IPlatformRunnable {
    private String _dir = null;
    private boolean _verbose = false;
    static Boolean _passed = null;

    boolean isVerbose() {
        return this._verbose;
    }

    void setVerbose(boolean v) {
        this._verbose = v;
    }

    String getDir() {
        return this._dir;
    }

    void setDir(String dir) {
        this._dir = dir;
    }

    private void parseUserSettings(Object args) {
        if (args == null) {
            return;
        }
        if (args instanceof String[]) {
            String[] userSettings = (String[])args;
            if (userSettings.length == 0) {
                return;
            }
            int i = 0;
            while (i < userSettings.length) {
                if (userSettings[i].equals("-dir")) {
                    this.setDir(userSettings[i + 1]);
                }
                if (userSettings[i].equals("-trace")) {
                    this.setVerbose(true);
                }
                ++i;
            }
            if (this.isVerbose()) {
                BVTValidationPlugin.getPlugin().getMsgLogger().setLevel(Level.FINEST);
            }
        }
    }

    public Object run(Object args) throws BVTValidationException {
        this.parseUserSettings(args);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) {
                block2: {
                    try {
                        monitor.subTask("Workspace is located at: " + BVTValidationPlugin.getPlugin().getStateLocation().toOSString());
                        ConsoleBuffer buffer = new ConsoleBuffer();
                        BVTRunner.singleton().setupTests(buffer, BVTValidationBatch.this.isVerbose());
                        int numTests = BVTValidationUtility.numValidatorTests(monitor, ResourcesPlugin.getWorkspace().getRoot().getProjects());
                        int numPassed = BVTRunner.singleton().test(buffer, ResourcesPlugin.getWorkspace().getRoot().getProjects());
                        _passed = numPassed == numTests ? Boolean.TRUE : Boolean.FALSE;
                    }
                    catch (BVTValidationException exc) {
                        Logger logger = BVTValidationPlugin.getPlugin().getMsgLogger();
                        if (!logger.isLoggingLevel(Level.SEVERE)) break block2;
                        logger.write(Level.SEVERE, exc.getMessage());
                        logger.write(Level.SEVERE, (Exception)exc);
                        if (exc.getTargetException() == null) break block2;
                        logger.write(Level.SEVERE, exc.getTargetException());
                    }
                }
            }
        };
        try {
            ConsoleProgressMonitor monitor = new ConsoleProgressMonitor();
            ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)monitor);
        }
        catch (CoreException exc) {
            throw new BVTValidationException(exc);
        }
        return _passed;
    }
}

