/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.tests.encoding.read;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.xml.tests.encoding.TestsPlugin;
import org.eclipse.wst.xml.tests.encoding.util.ProjectUnzipUtility;

public class TestContentTypeDetection
extends TestCase {
    private static final boolean DEBUG = false;
    static IProject fTestProject;
    private static boolean fTestProjectInitialized;
    private static int nSetups;
    private static final String TEST_PROJECT_NAME = "org.eclipse.wst.xml.temp.tests.encoding.resource.newtests";

    static {
        nSetups = 0;
    }

    /*
     * Exception decompiling
     */
    private static void createProject(IProject project, IPath locationPath, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 123->127)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void getAndCreateProject() throws CoreException {
        IWorkspace workspace = TestsPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        fTestProject = root.getProject(TEST_PROJECT_NAME);
        TestContentTypeDetection.createProject(fTestProject, null, null);
        fTestProject.refreshLocal(2, null);
        TestContentTypeDetection.assertTrue((boolean)fTestProject.exists());
    }

    protected void doTest(String expectedContentType, String filePath, Class expectedException) throws CoreException, IOException {
        IFile file = (IFile)fTestProject.findMember(filePath);
        TestContentTypeDetection.assertNotNull((String)("Error in test case: file not found: " + filePath), (Object)file);
        IContentDescription streamContentDescription = this.doGetContentTypeBasedOnStream(file);
        IContentDescription fileContentDescription = this.doGetContentTypeBasedOnFile(file);
        IContentType fileContentType = fileContentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"file content type was null", (Object)fileContentType);
        IContentType streamContentType = streamContentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"stream content type was null", (Object)streamContentType);
        TestContentTypeDetection.assertEquals((String)"comparing content type based on file and stream: ", (Object)fileContentType, (Object)streamContentType);
        TestContentTypeDetection.assertEquals((String)"compareing with expected content type id", (String)expectedContentType, (String)fileContentType.getId());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IContentDescription doGetContentTypeBasedOnStream(IFile file) throws CoreException, IOException {
        IContentDescription streamContentDescription;
        block4: {
            streamContentDescription = null;
            InputStream inputStream = null;
            try {
                inputStream = file.getContents();
                streamContentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, file.getName(), IContentDescription.ALL);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (inputStream == null) break block4;
            }
            inputStream.close();
        }
        TestContentTypeDetection.assertNotNull((String)"content description was null", (Object)streamContentDescription);
        return streamContentDescription;
    }

    protected IContentDescription doGetContentTypeBasedOnFile(IFile file) throws CoreException {
        IContentDescription fileContentDescription = file.getContentDescription();
        TestContentTypeDetection.assertNotNull((String)"file content description was null", (Object)fileContentDescription);
        return fileContentDescription;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTestForParent(String expectedContentType, String filePath, Class expectedException) throws CoreException, IOException {
        IContentDescription contentDescription;
        block7: {
            IFile file = (IFile)fTestProject.findMember(filePath);
            TestContentTypeDetection.assertNotNull((String)("Error in test case: file not found: " + filePath), (Object)file);
            contentDescription = file.getContentDescription();
            if (contentDescription == null) {
                InputStream inputStream = null;
                try {
                    inputStream = file.getContents();
                    contentDescription = Platform.getContentTypeManager().getDescriptionFor(inputStream, file.getName(), IContentDescription.ALL);
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                {
                    Object var7_10 = null;
                    if (inputStream == null) break block7;
                }
                inputStream.close();
            }
        }
        TestContentTypeDetection.assertNotNull((String)"content description was null", (Object)contentDescription);
        IContentType contentType = contentDescription.getContentType();
        TestContentTypeDetection.assertNotNull((String)"content type was null", (Object)contentType);
        IContentType parentContentType = contentType;
        boolean found = false;
        while (true) {
            if (parentContentType == null || found) {
                TestContentTypeDetection.assertTrue((String)("did not find '" + expectedContentType + "' in parent chain of base types"), (boolean)found);
                return;
            }
            found = expectedContentType.equals(parentContentType.getId());
            parentContentType = parentContentType.getBaseType();
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        ++nSetups;
        if (!fTestProjectInitialized) {
            TestContentTypeDetection.getAndCreateProject();
            String destinationProjectString = fTestProject.getLocation().toOSString();
            String destinationFolder = String.valueOf(destinationProjectString) + "/";
            File zipFile = TestsPlugin.getTestFile("testfiles.zip");
            ProjectUnzipUtility projUtil = new ProjectUnzipUtility();
            projUtil.unzipAndImport(zipFile, destinationFolder);
            projUtil.initJavaProject(TEST_PROJECT_NAME);
            fTestProject.refreshLocal(2, null);
            fTestProjectInitialized = true;
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (--nSetups == 0) {
            // empty if block
        }
    }

    protected static IProject getTestProject() {
        return fTestProject;
    }
}

