/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaQueryHint;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.mappings.IQuery;
import org.eclipse.jpt.core.internal.mappings.IQueryHint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaAbstractQuery
extends JavaEObject
implements IQuery {
    private final Member member;
    private final IndexedDeclarationAnnotationAdapter idaa;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final DeclarationAnnotationElementAdapter<String> queryDeclarationAdapter;
    private final IndexedAnnotationAdapter annotationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> queryAdapter;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String QUERY_EDEFAULT = null;
    protected String query = QUERY_EDEFAULT;
    protected EList<IQueryHint> hints;

    protected JavaAbstractQuery() {
        throw new UnsupportedOperationException("Use JavaAbstractQuery(Member) instead");
    }

    protected JavaAbstractQuery(Member member, IndexedDeclarationAnnotationAdapter idaa) {
        this.member = member;
        this.idaa = idaa;
        this.annotationAdapter = new MemberIndexedAnnotationAdapter(member, idaa);
        this.nameDeclarationAdapter = this.nameAdapter(this.idaa);
        this.queryDeclarationAdapter = this.queryAdapter(this.idaa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.queryAdapter = this.buildAdapter(this.queryDeclarationAdapter);
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    protected DeclarationAnnotationElementAdapter<String> nameAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, this.nameElementName());
    }

    protected DeclarationAnnotationElementAdapter<String> queryAdapter(DeclarationAnnotationAdapter daa) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(daa, this.queryElementName());
    }

    protected abstract String nameElementName();

    protected abstract String queryElementName();

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IQuery.class)) {
            case 0: {
                this.nameAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 1: {
                this.queryAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 2: {
                this.hintsChanged(notification);
                break;
            }
        }
    }

    void hintsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.hintAdded(notification.getPosition(), (IQueryHint)notification.getNewValue());
                break;
            }
            case 5: {
                this.hintsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.hintRemoved(notification.getPosition(), (IQueryHint)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.hintsCleared((List)notification.getOldValue());
                    break;
                }
                this.hintsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.hintSet(notification.getPosition(), (IQueryHint)notification.getOldValue(), (IQueryHint)notification.getNewValue());
                break;
            }
            case 7: {
                this.hintMoved(notification.getOldIntValue(), notification.getPosition(), (IQueryHint)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_ABSTRACT_QUERY;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(String newQuery) {
        String oldQuery = this.query;
        this.query = newQuery;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldQuery, (Object)this.query));
        }
    }

    @Override
    public EList<IQueryHint> getHints() {
        if (this.hints == null) {
            this.hints = new EObjectContainmentEList(IQueryHint.class, (InternalEObject)this, 2);
        }
        return this.hints;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getHints()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getQuery();
            }
            case 2: {
                return this.getHints();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setQuery((String)newValue);
                return;
            }
            case 2: {
                this.getHints().clear();
                this.getHints().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setQuery(QUERY_EDEFAULT);
                return;
            }
            case 2: {
                this.getHints().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return QUERY_EDEFAULT == null ? this.query != null : !QUERY_EDEFAULT.equals(this.query);
            }
            case 2: {
                return this.hints != null && !this.hints.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IQuery.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IQuery.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", query: ");
        result.append(this.query);
        result.append(')');
        return result.toString();
    }

    protected Member getMember() {
        return this.member;
    }

    public void hintAdded(int index, IQueryHint hint) {
        if (((JavaQueryHint)hint).annotation(this.getMember().astRoot()) == null) {
            this.synchHintAnnotationsAfterAdd(index + 1);
            ((JavaQueryHint)hint).newAnnotation();
        }
    }

    public void hintsAdded(int index, List<IQueryHint> queryHints) {
        if (!queryHints.isEmpty() && ((JavaQueryHint)queryHints.get(0)).annotation(this.getMember().astRoot()) == null) {
            this.synchHintAnnotationsAfterAdd(index + queryHints.size());
            for (IQueryHint hint : queryHints) {
                ((JavaQueryHint)hint).newAnnotation();
            }
        }
    }

    public void hintRemoved(int index, IQueryHint hint) {
        ((JavaQueryHint)hint).removeAnnotation();
        this.synchHintAnnotationsAfterRemove(index);
    }

    public void hintsRemoved(int[] indexes, List<IQueryHint> queryHints) {
        for (IQueryHint hint : queryHints) {
            ((JavaQueryHint)hint).removeAnnotation();
        }
        this.synchHintAnnotationsAfterRemove(indexes[0]);
    }

    public void hintsCleared(List<IQueryHint> queryHints) {
        for (IQueryHint hint : queryHints) {
            ((JavaQueryHint)hint).removeAnnotation();
        }
    }

    public void hintSet(int index, IQueryHint oldHint, IQueryHint newHint) {
        ((JavaQueryHint)newHint).newAnnotation();
    }

    public void hintMoved(int sourceIndex, int targetIndex, IQueryHint hint) {
        EList<IQueryHint> queryHints = this.getHints();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IQueryHint)queryHints.get(i), i);
        }
    }

    private void synchHintAnnotationsAfterAdd(int index) {
        EList<IQueryHint> queryHints = this.getHints();
        int i = queryHints.size();
        while (i-- > index) {
            this.synch((IQueryHint)queryHints.get(i), i);
        }
    }

    private void synchHintAnnotationsAfterRemove(int index) {
        EList<IQueryHint> queryHints = this.getHints();
        int i = index;
        while (i < queryHints.size()) {
            this.synch((IQueryHint)queryHints.get(i), i);
            ++i;
        }
    }

    private void synch(IQueryHint queryHint, int index) {
        ((JavaQueryHint)queryHint).moveAnnotation(index);
    }

    public Annotation annotation(CompilationUnit astRoot) {
        return this.annotationAdapter.getAnnotation(astRoot);
    }

    protected void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.nameAdapter.getValue(astRoot));
        this.setQuery(this.queryAdapter.getValue(astRoot));
        this.updateQueryHintsFromJava(astRoot);
    }

    /*
     * Unable to fully structure code
     */
    private void updateQueryHintsFromJava(CompilationUnit astRoot) {
        block5: {
            queryHints = this.getHints();
            persSize = queryHints.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                hint = (JavaQueryHint)queryHints.get(i);
                if (hint.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                hint.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                queryHints.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                javaQueryHint = this.createJavaQueryHint(javaSize);
                if (javaQueryHint.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getHints().add((Object)javaQueryHint);
                javaQueryHint.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    @Override
    public JavaQueryHint createQueryHint(int index) {
        return this.createJavaQueryHint(index);
    }

    protected abstract JavaQueryHint createJavaQueryHint(int var1);

    protected IndexedDeclarationAnnotationAdapter getDeclarationAnnotationAdapter() {
        return this.idaa;
    }

    void moveAnnotation(int newIndex) {
        this.annotationAdapter.moveAnnotation(newIndex);
    }

    void newAnnotation() {
        this.annotationAdapter.newMarkerAnnotation();
    }

    void removeAnnotation() {
        this.annotationAdapter.removeAnnotation();
    }

    @Override
    public ITextRange validationTextRange() {
        return this.member.annotationTextRange(this.idaa);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }
}

