/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.WARFile;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;

public class ClasspathDependencyWebTests
extends AbstractTests {
    private static final String UTIL_PROJECT = "TestUtil";
    private static final String WEB_PROJECT = "TestWeb";

    private ClasspathDependencyWebTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Dependency Web Tests");
        suite.addTest((Test)new ClasspathDependencyWebTests("testWebExport"));
        suite.addTest((Test)new ClasspathDependencyWebTests("testWebPublish"));
        return suite;
    }

    public void testWebExport() throws Exception {
        IVirtualComponent webComp = this.createProjects();
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyExportedWebInfLibs(webComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyExportedWebInfLibs(webComp, archiveNames, true);
    }

    private void verifyExportedWebInfLibs(IVirtualComponent comp, Set archiveNames, boolean shouldHaveArchives) throws Exception {
        WebArtifactEdit webEdit = null;
        WARFile warFile = null;
        try {
            webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)comp);
            if (webEdit != null) {
                warFile = (WARFile)webEdit.asArchive(true);
                List libArchives = warFile.getLibArchives();
                for (String name : archiveNames) {
                    boolean hasArchive = false;
                    int i = 0;
                    while (i < libArchives.size()) {
                        File archive = (File)libArchives.get(i);
                        if (archive.isArchive() && archive.getName().equals(name)) {
                            hasArchive = true;
                        }
                        ++i;
                    }
                    if (shouldHaveArchives) {
                        ClasspathDependencyWebTests.assertTrue((String)("Exported WAR missing classpath dependency Jar " + name), (boolean)hasArchive);
                        continue;
                    }
                    ClasspathDependencyWebTests.assertFalse((String)("Exported WAR has unexpected classpath dependency Jar " + name), (boolean)hasArchive);
                }
            }
        }
        finally {
            if (webEdit != null) {
                webEdit.dispose();
            }
            if (warFile != null) {
                warFile.close();
            }
        }
    }

    public void testWebPublish() throws Exception {
        IVirtualComponent webComp = this.createProjects();
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyPublishedWebInfLibs(webComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyPublishedWebInfLibs(webComp, archiveNames, true);
    }

    private void verifyPublishedWebInfLibs(IVirtualComponent comp, Set archiveNames, boolean shouldHaveArchives) throws Exception {
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(comp.getProject(), comp);
        try {
            IModuleResource[] members = deployable.members();
            ClasspathDependencyWebTests.assertTrue((members.length == 2 ? 1 : 0) != 0);
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (name.equals("WEB-INF")) {
                    IModuleResource[] webInf = ((ModuleFolder)members[i]).members();
                    int j = 0;
                    while (j < webInf.length) {
                        IModuleResource webResource = webInf[j];
                        ClasspathDependencyWebTests.assertTrue((boolean)webResource.getModuleRelativePath().toString().equals("WEB-INF"));
                        if (webResource.getName().equals("lib")) {
                            IModuleResource[] webresMembers = ((ModuleFolder)webResource).members();
                            for (String archiveName : archiveNames) {
                                boolean hasArchive = false;
                                int k = 0;
                                while (k < webresMembers.length) {
                                    String localName = webresMembers[k].getName();
                                    if (localName.equals(archiveName)) {
                                        hasArchive = true;
                                    }
                                    ++k;
                                }
                                if (shouldHaveArchives) {
                                    ClasspathDependencyWebTests.assertTrue((String)("Published WAR missing classpath dependency Jar " + archiveName), (boolean)hasArchive);
                                    continue;
                                }
                                ClasspathDependencyWebTests.assertFalse((String)("Published WAR has unexpected classpath dependency Jar " + archiveName), (boolean)hasArchive);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            ClasspathDependencyWebTests.fail((String)e.getMessage());
        }
    }

    private IVirtualComponent createProjects() throws Exception {
        IProject util = ProjectUtil.createUtilityProject(UTIL_PROJECT, null, true);
        IJavaProject utilJava = JavaCore.create((IProject)util);
        ComponentCore.createComponent((IProject)util);
        IProject webProject = ProjectUtil.createWebProject(WEB_PROJECT, null, true);
        JavaCore.create((IProject)webProject);
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        DependencyCreationUtil.createWebLibDependency(webProject, util);
        ClasspathDependencyTestUtil.addCustomClasspathContainer(utilJava);
        return webComp;
    }

    private void addDependencyAttribute() throws Exception {
        IProject util = ProjectUtil.getProject(UTIL_PROJECT);
        IJavaProject utilJava = JavaCore.create((IProject)util);
        IVirtualComponent utilComp = ComponentCore.createComponent((IProject)util);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.CUSTOM_CLASSPATH_CONTAINER);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(utilJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(utilComp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(utilJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(utilJava, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp, archiveNames);
    }
}

