/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.tests;

import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jst.common.frameworks.CommonFrameworksPlugin;
import org.eclipse.jst.common.project.facet.JavaFacetInstallDataModelProvider;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.earcreation.IEarFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.ejb.project.operations.IEjbFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionUtil;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.facet.IAppClientFacetInstallDataModelProperties;
import org.eclipse.jst.j2ee.web.project.facet.IWebFacetInstallDataModelProperties;
import org.eclipse.jst.javaee.core.JavaeeFactory;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.impl.WTPResourceFactoryRegistry;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.operations.IHeadlessRunnableWithProgress;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.tests.SimpleTestSuite;

public class ModelProviderTest
extends GeneralEMFPopulationTest {
    private static final String PROJECTNAME = "TestModelProviders";
    private final String descText = "Testing setting the desc";

    public ModelProviderTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SimpleTestSuite(ModelProviderTest.class);
    }

    protected Object primCreateAttributeValue(EAttribute att, EObject eObject) {
        if (att.getEAttributeType() == XMLTypePackage.eINSTANCE.getQName()) {
            return null;
        }
        return super.primCreateAttributeValue(att, eObject);
    }

    protected void setUp() throws Exception {
        super.setUp();
        final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.getRoot().getProject(PROJECTNAME).isAccessible()) {
            return;
        }
        final IProjectDescription description = workspace.newProjectDescription(PROJECTNAME);
        description.setLocation(null);
        IHeadlessRunnableWithProgress op = new IHeadlessRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    ModelProviderTest.this.createProject(description, workspace.getRoot().getProject(ModelProviderTest.PROJECTNAME), monitor);
                }
                catch (OperationCanceledException e) {
                    e.printStackTrace();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            op.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        finally {
            monitor.done();
        }
    }

    public void testUseEar5Model() throws Exception {
        String projName = "TestEE5EarProject";
        IProject earProj = this.createEarProject(projName, 50);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)earProj);
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.javaee.application.Application ear = (org.eclipse.jst.javaee.application.Application)provider.getModelObject();
                if (ear.getDescriptions().isEmpty()) {
                    ear.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)ear.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, null);
        earProj.close((IProgressMonitor)new NullProgressMonitor());
        earProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)earProj);
        org.eclipse.jst.javaee.application.Application sameEar = (org.eclipse.jst.javaee.application.Application)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameEar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseEar5NoDDModel() throws Exception {
        String projName = "TestEE5EarProject";
        IProject earProj = this.createEarProject(projName, 50);
        IFolder contentFolder = earProj.getFolder(J2EEPlugin.getDefault().getJ2EEPreferences().getString("earContent"));
        IFile ddFile = contentFolder.getFile("META-INF/application.xml");
        if (ddFile.exists()) {
            ddFile.delete(true, null);
        }
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)earProj);
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.javaee.application.Application ear = (org.eclipse.jst.javaee.application.Application)provider.getModelObject();
                if (ear.getDescriptions().isEmpty()) {
                    ear.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)ear.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, IModelProvider.FORCESAVE);
        earProj.close((IProgressMonitor)new NullProgressMonitor());
        earProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)earProj);
        org.eclipse.jst.javaee.application.Application sameEar = (org.eclipse.jst.javaee.application.Application)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameEar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseEar14Model() throws Exception {
        String projName = "TestEE14EarProject";
        IProject earProj = this.createEarProject(projName, 14);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)earProj);
        Application cfr_ignored_0 = (Application)provider.getModelObject((IPath)new Path("META-INF/application.xml"));
        provider.modify(new Runnable(){

            public void run() {
                Application ear = (Application)provider.getModelObject();
                ear.setDescription("Testing setting the desc");
            }
        }, null);
        earProj.close((IProgressMonitor)new NullProgressMonitor());
        earProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)earProj);
        Application sameEar = (Application)newProvider.getModelObject();
        Description desc = (Description)sameEar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseWeb25Model() throws Exception {
        String projName = "TestEE5WebProject";
        IProject webProj = this.createWebProject(projName, 25);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProj);
        provider.modify(new Runnable(){

            public void run() {
                WebApp webApp = (WebApp)provider.getModelObject();
                if (webApp.getDescriptions().isEmpty()) {
                    webApp.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)webApp.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, null);
        webProj.close((IProgressMonitor)new NullProgressMonitor());
        webProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)webProj);
        WebApp sameWebApp = (WebApp)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameWebApp.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseWeb25NoDDModel() throws Exception {
        String projName = "TestEE5WebProject";
        IProject webProj = this.createWebProject(projName, 25);
        IFolder contentFolder = webProj.getFolder(J2EEPlugin.getDefault().getJ2EEPreferences().getString("webContent"));
        IFile ddFile = contentFolder.getFile("WEB-INF/web.xml");
        if (ddFile.exists()) {
            ddFile.delete(true, null);
        }
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProj);
        provider.modify(new Runnable(){

            public void run() {
                WebApp webApp = (WebApp)provider.getModelObject();
                if (webApp.getDescriptions().isEmpty()) {
                    webApp.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)webApp.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, IModelProvider.FORCESAVE);
        webProj.close((IProgressMonitor)new NullProgressMonitor());
        webProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)webProj);
        WebApp sameWebApp = (WebApp)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameWebApp.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseWeb24Model() throws Exception {
        String projName = "TestEE14WebProject";
        IProject webProj = this.createWebProject(projName, 24);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)webProj);
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)provider.getModelObject();
                webApp.setDescription("Testing setting the desc");
            }
        }, null);
        webProj.close((IProgressMonitor)new NullProgressMonitor());
        webProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)webProj);
        org.eclipse.jst.j2ee.webapplication.WebApp sameWebApp = (org.eclipse.jst.j2ee.webapplication.WebApp)newProvider.getModelObject();
        Description desc = (Description)sameWebApp.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseEjb3NoDDModel() throws Exception {
        String projName = "TestEE5EjbProject";
        IProject ejbProj = this.createEjbProject(projName, 30);
        IFolder ejbFolder = ejbProj.getFolder(J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent"));
        IFile ejbJarXmlFile = ejbFolder.getFile("META-INF/ejb-jar.xml");
        if (ejbJarXmlFile.exists()) {
            ejbJarXmlFile.delete(true, null);
        }
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        provider.modify(new Runnable(){

            public void run() {
                EJBJar ejbJar = (EJBJar)provider.getModelObject();
                if (ejbJar.getDescriptions().isEmpty()) {
                    ejbJar.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)ejbJar.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, IModelProvider.FORCESAVE);
        ejbProj.close((IProgressMonitor)new NullProgressMonitor());
        ejbProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        EJBJar sameEjbJar = (EJBJar)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameEjbJar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseEjb3Model() throws Exception {
        String projName = "TestEE5EjbProject";
        IProject ejbProj = this.createEjbProject(projName, 30);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        provider.modify(new Runnable(){

            public void run() {
                EJBJar ejbJar = (EJBJar)provider.getModelObject();
                if (ejbJar.getDescriptions().isEmpty()) {
                    ejbJar.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)ejbJar.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, null);
        ejbProj.close((IProgressMonitor)new NullProgressMonitor());
        ejbProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        EJBJar sameEjbJar = (EJBJar)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameEjbJar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseEjb21Model() throws Exception {
        String projName = "TestEE14EjbProject";
        IProject ejbProj = this.createEjbProject(projName, 21);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.j2ee.ejb.EJBJar ejbJar = (org.eclipse.jst.j2ee.ejb.EJBJar)provider.getModelObject();
                ejbJar.setDescription("Testing setting the desc");
            }
        }, null);
        ejbProj.close((IProgressMonitor)new NullProgressMonitor());
        ejbProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)ejbProj);
        org.eclipse.jst.j2ee.ejb.EJBJar sameEjbJar = (org.eclipse.jst.j2ee.ejb.EJBJar)newProvider.getModelObject();
        Description desc = (Description)sameEjbJar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    private ProjectResourceSet getResourceSet(String projName) {
        IProject proj = this.getProject(projName);
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj);
    }

    private IProject createWebProject(String projName, int vers) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IWebFacetInstallDataModelProperties.class);
        String webVersionString = J2EEVersionUtil.convertVersionIntToString((int)vers);
        IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"jst.web");
        IProjectFacetVersion webFacetVersion = webFacet.getVersion(webVersionString);
        this.addWebProjectProperties(dataModel, projName, webFacetVersion);
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, CommonFrameworksPlugin.getDefault().getPluginPreferences().getString("defaultSource")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createEjbProject(String projName, int vers) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEjbFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)vers);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ejb");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ejb");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, J2EEPlugin.getDefault().getJ2EEPreferences().getString("ejbContent")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createEarProject(String projName, int vers) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IEarFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)vers);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.ear");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.ear");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    private IProject createAppClientProject(String projName, int vers) throws ExecutionException {
        IDataModel dataModel = DataModelFactory.createDataModel(IAppClientFacetInstallDataModelProperties.class);
        String versionString = J2EEVersionUtil.convertVersionIntToString((int)vers);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)"jst.appclient");
        IProjectFacetVersion facetVersion = facet.getVersion(versionString);
        this.addVersionProperties(dataModel, projName, facetVersion, "jst.appclient");
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        map.add(this.setupJavaInstallAction(projName, J2EEPlugin.getDefault().getJ2EEPreferences().getString("appClientContent")));
        dataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        IProject webProj = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
        return webProj;
    }

    protected IDataModel setupJavaInstallAction(String aProjectName, String srcFolder) {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new JavaFacetInstallDataModelProvider());
        dm.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)aProjectName);
        String jVersion = "5.0";
        dm.setProperty("IFacetDataModelProperties.FACET_VERSION_STR", (Object)jVersion);
        dm.setStringProperty("IJavaFacetInstallDataModelProperties.SOURCE_FOLDER_NAME", srcFolder);
        return dm;
    }

    private void addWebProjectProperties(IDataModel dataModel, String projName, IProjectFacetVersion web25) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel webmodel = (IDataModel)map.get((Object)"jst.web");
        webmodel.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)web25);
    }

    private void addVersionProperties(IDataModel dataModel, String projName, IProjectFacetVersion fv, String facetString) {
        dataModel.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)projName);
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)dataModel.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel model = (IDataModel)map.get((Object)facetString);
        model.setBooleanProperty("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        model.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)fv);
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECTNAME);
    }

    public IProject getProject(String projName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
    }

    private void registerFactory(URI uri, ResourceSet resSet, Resource.Factory factory) {
        WTPResourceFactoryRegistry registry = (WTPResourceFactoryRegistry)resSet.getResourceFactoryRegistry();
        registry.registerLastFileSegment(uri.lastSegment(), factory);
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl set = new ResourceSetImpl();
        set.setResourceFactoryRegistry((Resource.Factory.Registry)WTPResourceFactoryRegistry.INSTANCE);
        return set;
    }

    protected void tearDown() throws Exception {
    }

    public void testUseAppClient14Model() throws Exception {
        String projName = "TestEE14AppClientProject";
        IProject appClientProj = this.createAppClientProject(projName, 14);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        ApplicationClient cfr_ignored_0 = (ApplicationClient)provider.getModelObject((IPath)new Path("META-INF/application-client.xml"));
        provider.modify(new Runnable(){

            public void run() {
                ApplicationClient client = (ApplicationClient)provider.getModelObject();
                client.setDescription("Testing setting the desc");
            }
        }, null);
        appClientProj.close((IProgressMonitor)new NullProgressMonitor());
        appClientProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        ApplicationClient sameEar = (ApplicationClient)newProvider.getModelObject();
        Description desc = (Description)sameEar.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseAppClient5Model() throws Exception {
        String projName = "TestEE5AppClientProject";
        IProject appClientProj = this.createAppClientProject(projName, 50);
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        org.eclipse.jst.javaee.applicationclient.ApplicationClient cfr_ignored_0 = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)provider.getModelObject((IPath)new Path("META-INF/application-client.xml"));
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.javaee.applicationclient.ApplicationClient client = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)provider.getModelObject();
                if (client.getDescriptions().isEmpty()) {
                    client.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)client.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, null);
        appClientProj.close((IProgressMonitor)new NullProgressMonitor());
        appClientProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        org.eclipse.jst.javaee.applicationclient.ApplicationClient sameClient = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameClient.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }

    public void testUseAppClient5NoDDModel() throws Exception {
        String projName = "TestEE5AppClientProject";
        IProject appClientProj = this.createAppClientProject(projName, 50);
        IFolder contentFolder = appClientProj.getFolder(J2EEPlugin.getDefault().getJ2EEPreferences().getString("appClientContent"));
        IFile ddFile = contentFolder.getFile("META-INF/application-client.xml");
        if (ddFile.exists()) {
            ddFile.delete(true, null);
        }
        final IModelProvider provider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        org.eclipse.jst.javaee.applicationclient.ApplicationClient cfr_ignored_0 = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)provider.getModelObject((IPath)new Path("META-INF/application-client.xml"));
        provider.modify(new Runnable(){

            public void run() {
                org.eclipse.jst.javaee.applicationclient.ApplicationClient client = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)provider.getModelObject();
                if (client.getDescriptions().isEmpty()) {
                    client.getDescriptions().add(JavaeeFactory.eINSTANCE.createDescription());
                }
                org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)client.getDescriptions().get(0);
                desc.setValue("Testing setting the desc");
            }
        }, IModelProvider.FORCESAVE);
        appClientProj.close((IProgressMonitor)new NullProgressMonitor());
        appClientProj.open((IProgressMonitor)new NullProgressMonitor());
        IModelProvider newProvider = ModelProviderManager.getModelProvider((IProject)appClientProj);
        org.eclipse.jst.javaee.applicationclient.ApplicationClient sameClient = (org.eclipse.jst.javaee.applicationclient.ApplicationClient)newProvider.getModelObject();
        org.eclipse.jst.javaee.core.Description desc = (org.eclipse.jst.javaee.core.Description)sameClient.getDescriptions().get(0);
        Assert.assertEquals((String)"Testing setting the desc", (String)desc.getValue());
    }
}

