/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.ear.operations;

import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.application.internal.operations.EARComponentExportDataModelProvider;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.tests.AssertWarn;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wtp.j2ee.headless.tests.appclient.operations.AppClientExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARProjectCreationOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.ejb.operations.EJBExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ArchiveTestsUtil;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JEEExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaEEFacetConstants;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.JavaFileTestingUtilities;
import org.eclipse.wtp.j2ee.headless.tests.jca.operations.JCAExportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.web.operations.WebExportOperationTest;

public class EARExportOperationTest
extends JEEExportOperationTest {
    private static final String JAR_EXTENSION = "jar";
    private static final String RAR_EXTENSION = "rar";
    private static final String WAR_EXTENSION = "war";

    public EARExportOperationTest() {
        super("EARExportOperationTests");
    }

    public EARExportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(EARExportOperationTest.class);
        return suite;
    }

    public void testEARExport12_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport13_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport14_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport50_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport12_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("zEAR", "myContent", EARProjectCreationOperationTest.getJ2EEDependencyList_12(), EARProjectCreationOperationTest.getJavaDependencyList_12(), JavaEEFacetConstants.EAR_12, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport13_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("yEAR", "ourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_13(), EARProjectCreationOperationTest.getJavaDependencyList_13(), JavaEEFacetConstants.EAR_13, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport14_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("xEAR", "theirContent", EARProjectCreationOperationTest.getJ2EEDependencyList_14(), EARProjectCreationOperationTest.getJavaDependencyList_14(), JavaEEFacetConstants.EAR_14, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport50_ChangedContentDir_WithDependencies() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("wEAR", "yourContent", EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, false);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport50_WithDependencies_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("anEAR", null, EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    public void testEARExport50_ChangedContentDir_WithDependencies_WithDD() throws Exception {
        IDataModel dm = EARProjectCreationOperationTest.getEARDataModel("theirEAR", "gotContent", EARProjectCreationOperationTest.getJ2EEDependencyList_5(), EARProjectCreationOperationTest.getJavaDependencyList_5(), JavaEEFacetConstants.EAR_5, true);
        OperationTestCase.runDataModel((IDataModel)dm);
        this.runExportTests_All(dm);
    }

    protected String getModuleExtension() {
        return ".ear";
    }

    protected IDataModel getExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        return EARExportOperationTest.getEARExportDataModel(projectName, destination, exportSource, runBuild, overwriteExisting);
    }

    public static IDataModel getEARExportDataModel(String projectName, String destination, boolean exportSource, boolean runBuild, boolean overwriteExisting) {
        IDataModel exportModel = DataModelFactory.createDataModel((IDataModelProvider)new EARComponentExportDataModelProvider());
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.PROJECT_NAME", (Object)projectName);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.ARCHIVE_DESTINATION", (Object)destination);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.EXPORT_SOURCE_FILES", (Object)exportSource);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.OVERWRITE_EXISTING", (Object)overwriteExisting);
        exportModel.setProperty("IJ2EEComponentExportDataModelProperties.RUN_BUILD", (Object)runBuild);
        return exportModel;
    }

    protected void runExportTests_All(IDataModel creationModel) throws Exception {
        String projectName = creationModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
        String archiveName = null;
        String archivePath = null;
        IProject earProject = J2EEProjectUtilities.getProject((String)projectName);
        JavaFileTestingUtilities.addJavaFilesToAllProjectsInEAR(earProject);
        archiveName = this.runAndVerifyExport_Defaults(projectName);
        archivePath = EARExportOperationTest.getDataPath(archiveName);
        JavaFileTestingUtilities.verifyAllJavaFilesExportedToProjectsInEAR(archivePath, true, false);
        EARExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_WithSource(projectName);
        archivePath = EARExportOperationTest.getDataPath(archiveName);
        JavaFileTestingUtilities.verifyAllJavaFilesExportedToProjectsInEAR(archivePath, true, true);
        EARExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_DontRunBuild(projectName);
        archivePath = EARExportOperationTest.getDataPath(archiveName);
        EARExportOperationTest.deleteExported(archivePath);
        archiveName = this.runAndVerifyExport_WithSource_DontRunBuild(projectName);
        archivePath = EARExportOperationTest.getDataPath(archiveName);
        JavaFileTestingUtilities.verifyAllJavaFilesExportedToProjectsInEAR(archivePath, false, true);
        EARExportOperationTest.deleteExported(archivePath);
        this.runTest_AttemptToOverwriteButCant(projectName);
        this.runTest_AttemptToOverwriteSholdSucceed(projectName);
        this.runAndVerify_CompareProjectsExportedAloneAndExportedInEAR(projectName);
        JavaFileTestingUtilities.clearJavaFilesForEAR();
    }

    private void runAndVerify_CompareProjectsExportedAloneAndExportedInEAR(String projectName) throws Exception {
        String archiveName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "_" + this.getName() + "_ExportedNestedArchivesTest" + this.getModuleExtension();
        String destination = EARExportOperationTest.getDataPath(archiveName);
        IArchive earArchive = null;
        try {
            IDataModel exportModel = this.getExportDataModel(projectName, destination, true, true, true);
            EARExportOperationTest.runAndVerify((IDataModel)exportModel);
            earArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(destination));
            List resources = earArchive.getArchiveResources();
            String extension = null;
            for (IArchiveResource resource : resources) {
                extension = resource.getPath().getFileExtension();
                if (extension == null || !extension.equals(JAR_EXTENSION) && !extension.equals(RAR_EXTENSION) && !extension.equals(WAR_EXTENSION)) continue;
                earArchive.getNestedArchive(resource);
            }
            IProject earProject = J2EEProjectUtilities.getProject((String)projectName);
            IProject[] referencedProjects = earProject.getReferencedProjects();
            String referencedProjectType = null;
            String referencedArchiveProjectName = null;
            String referencedArchiveDestination = null;
            IDataModel referencedArchiveExportModel = null;
            HashMap<String, Path> referencedProjectsArchiveMap = new HashMap<String, Path>();
            IProject[] iProjectArray = referencedProjects;
            int n = referencedProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject referencedProject = iProjectArray[n2];
                referencedProjectType = J2EEProjectUtilities.getJ2EEProjectType((IProject)referencedProject);
                referencedArchiveProjectName = referencedProject.getName();
                referencedArchiveDestination = EARExportOperationTest.getDataPath(referencedArchiveProjectName);
                if (referencedProjectType.equals("jst.appclient")) {
                    referencedArchiveDestination = String.valueOf(referencedArchiveDestination) + ".jar";
                    referencedArchiveExportModel = AppClientExportOperationTest.getAppClientExportDataModel(referencedArchiveProjectName, referencedArchiveDestination, true, true, true);
                } else if (referencedProjectType.equals("jst.web")) {
                    referencedArchiveDestination = String.valueOf(referencedArchiveDestination) + ".war";
                    referencedArchiveExportModel = WebExportOperationTest.getWebExportDataModel(referencedArchiveProjectName, referencedArchiveDestination, true, true, true, false);
                } else if (referencedProjectType.equals("jst.ejb")) {
                    referencedArchiveDestination = String.valueOf(referencedArchiveDestination) + ".jar";
                    referencedArchiveExportModel = EJBExportOperationTest.getEJBExportDataModel(referencedArchiveProjectName, referencedArchiveDestination, true, true, true);
                } else if (referencedProjectType.equals("jst.connector")) {
                    referencedArchiveDestination = String.valueOf(referencedArchiveDestination) + ".rar";
                    referencedArchiveExportModel = JCAExportOperationTest.getRARExportDataModel(referencedArchiveProjectName, referencedArchiveDestination, true, true, true);
                }
                EARExportOperationTest.runAndVerify(referencedArchiveExportModel);
                referencedProjectsArchiveMap.put(referencedArchiveProjectName, new Path(referencedArchiveDestination));
                ++n2;
            }
            List nestedArchives = earArchive.getNestedArchives();
            String nestedArchiveName = null;
            IPath referencedProjectArchivePath = null;
            IArchive referencedProjectArchive = null;
            for (IArchive nestedArchive : nestedArchives) {
                nestedArchiveName = nestedArchive.getPath().removeFileExtension().lastSegment();
                referencedProjectArchivePath = (IPath)referencedProjectsArchiveMap.get(nestedArchiveName);
                AssertWarn.warnNotNull((String)"There should be an exported project archive path for this EAR's nested archive", (Object)referencedProjectArchivePath);
                if (referencedProjectArchivePath == null) continue;
                try {
                    referencedProjectArchive = JavaEEArchiveUtilities.INSTANCE.openArchive(referencedProjectArchivePath);
                    ArchiveTestsUtil.compareArchives(referencedProjectArchive, nestedArchive);
                }
                finally {
                    if (referencedProjectArchive != null) {
                        JavaEEArchiveUtilities.INSTANCE.closeArchive(referencedProjectArchive);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (earArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(earArchive);
            }
            EARExportOperationTest.deleteExported(archiveName);
            throw throwable;
        }
        if (earArchive != null) {
            JavaEEArchiveUtilities.INSTANCE.closeArchive(earArchive);
        }
        EARExportOperationTest.deleteExported(archiveName);
    }
}

