/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.operations;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.j2ee.internal.archive.JavaEEArchiveUtilities;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.tests.OperationTestCase;
import org.eclipse.wst.common.tests.ProjectUtility;
import org.eclipse.wtp.j2ee.headless.tests.ear.operations.EARImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.operations.ModuleImportOperationTest;
import org.eclipse.wtp.j2ee.headless.tests.plugin.HeadlessTestsPlugin;

public abstract class JEEImportOperationTest
extends OperationTestCase {
    private static final String BASE_IMPORT_DIR = "TestData" + File.separatorChar + "JEEImportOperationTests" + File.separatorChar;
    private static final String TEMP_EXPORT_DIR = String.valueOf(System.getProperty("user.dir")) + File.separatorChar + "JEEExportOperationTests" + File.separatorChar;

    public JEEImportOperationTest() {
        super("JEEImportOperationTests");
    }

    public JEEImportOperationTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(ModuleImportOperationTest.suite());
        suite.addTest(EARImportOperationTest.suite());
        return suite;
    }

    protected String getTestDataDirectoryName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected String getArchivePath(String archiveName) throws Exception {
        HeadlessTestsPlugin plugin = HeadlessTestsPlugin.getDefault();
        String pluginRelativeFileName = String.valueOf(BASE_IMPORT_DIR) + this.getTestDataDirectoryName() + File.separatorChar + archiveName;
        return ProjectUtility.getFullFileName((Plugin)plugin, (String)pluginRelativeFileName);
    }

    protected String getExportPath(String archiveName) throws Exception {
        return String.valueOf(TEMP_EXPORT_DIR) + archiveName;
    }

    protected abstract IDataModel getImportDataModel(String var1, String var2, IOverwriteHandler var3, IDataModel var4, boolean var5) throws Exception;

    protected abstract IDataModel getExportDataModel(String var1, String var2, boolean var3, boolean var4, boolean var5);

    protected void runImportTests_All(String testName) throws Exception {
        String archiveName = null;
        archiveName = String.valueOf(testName) + "_Defaults" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedDefaults(archiveName);
        OperationTestCase.deleteAllProjects();
        archiveName = String.valueOf(testName) + "_Source" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSource(archiveName);
        OperationTestCase.deleteAllProjects();
        archiveName = String.valueOf(testName) + "_NoBuild" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithDontRunBuild(archiveName);
        OperationTestCase.deleteAllProjects();
        archiveName = String.valueOf(testName) + "_Source_NoBuild" + this.getModuleExtension();
        this.runAndVerifyImport_ExportedWithSrouce_ExportedWithDontRunBuild(archiveName);
        OperationTestCase.deleteAllProjects();
    }

    protected abstract String getModuleExtension();

    protected void runAndVerifyImport_ExportedDefaults(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedDefaults";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, null, true);
        OperationTestCase.runAndVerify((IDataModel)importModel);
        this.runAndVerifyReExportation(importModel, true, true);
    }

    protected void runAndVerifyImport_ExportedWithSource(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedWithSource";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, null, true);
        JEEImportOperationTest.runAndVerify((IDataModel)importModel);
        this.runAndVerifyReExportation(importModel, true, true);
    }

    protected void runAndVerifyImport_ExportedWithDontRunBuild(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedWithDontRunBuild";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, null, true);
        JEEImportOperationTest.runAndVerify((IDataModel)importModel);
    }

    protected void runAndVerifyImport_ExportedWithSrouce_ExportedWithDontRunBuild(String archiveName) throws Exception {
        String archivePath = this.getArchivePath(archiveName);
        String projectName = "exportedWithSourceAndDontRunBuild";
        this.verifyImportArchiveExists(archivePath);
        IDataModel importModel = this.getImportDataModel(archivePath, projectName, null, null, true);
        JEEImportOperationTest.runAndVerify((IDataModel)importModel);
    }

    protected void runAndVerifyReExportation(IDataModel importModel, boolean exportSource, boolean runBuild) throws Exception {
        IArchive importedArchive = null;
        IArchive exportedArchive = null;
        String projectName = importModel.getStringProperty("IJ2EEComponentImportDataModelProperties.PROJECT_NAME");
        String importedArchivePath = importModel.getStringProperty("IJ2EEArtifactImportDataModelProperties.FILE_NAME");
        String exportDestination = this.getExportPath(String.valueOf(projectName) + this.getModuleExtension());
        try {
            IDataModel exportModel = this.getExportDataModel(projectName, exportDestination, exportSource, runBuild, true);
            OperationTestCase.runAndVerify((IDataModel)exportModel);
            importedArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(importedArchivePath));
            exportedArchive = JavaEEArchiveUtilities.INSTANCE.openArchive((IPath)new Path(exportDestination));
            List importedArchiveResources = importedArchive.getArchiveResources();
            List exportedArchiveResources = exportedArchive.getArchiveResources();
            ArrayList<IPath> importedArchiveFileResourcePaths = new ArrayList<IPath>();
            ArrayList<IPath> exportedArchiveFileResourcePaths = new ArrayList<IPath>();
            ArrayList<IPath> importedArchiveDirResourcePaths = new ArrayList<IPath>();
            ArrayList<IPath> exportedArchiveDirResourcePaths = new ArrayList<IPath>();
            for (IArchiveResource importedArchiveResource : importedArchiveResources) {
                if (importedArchiveResource.getType() == 1) {
                    importedArchiveDirResourcePaths.add(importedArchiveResource.getPath());
                    continue;
                }
                importedArchiveFileResourcePaths.add(importedArchiveResource.getPath());
            }
            for (IArchiveResource exportedArchiveResource : exportedArchiveResources) {
                if (exportedArchiveResource.getType() == 1) {
                    exportedArchiveDirResourcePaths.add(exportedArchiveResource.getPath());
                    continue;
                }
                exportedArchiveFileResourcePaths.add(exportedArchiveResource.getPath());
            }
            if (exportedArchiveFileResourcePaths.contains(new Path("/"))) {
                Assert.fail((String)"Exported Archive should not contain a root entry '/'");
            }
            ArrayList<IPath> missingFromImport = new ArrayList<IPath>();
            for (IPath importedPath : importedArchiveDirResourcePaths) {
                boolean exported = exportedArchiveDirResourcePaths.contains(importedPath);
                if (exported || importedPath.lastSegment() == null) continue;
                missingFromImport.add(importedPath);
            }
            ArrayList<IPath> missingFromExport = new ArrayList<IPath>();
            for (IPath importedPath : importedArchiveFileResourcePaths) {
                boolean exported = exportedArchiveFileResourcePaths.remove(importedPath);
                if (exported || importedPath.lastSegment() == null) continue;
                missingFromExport.add(importedPath);
            }
            if (!missingFromExport.isEmpty() || !missingFromImport.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                if (!missingFromExport.isEmpty()) {
                    buffer.append("The following are missing from the exported IArchive:\n");
                    for (IPath path : missingFromExport) {
                        buffer.append(path + "\n");
                    }
                }
                if (!missingFromImport.isEmpty()) {
                    buffer.append("The following are missing from the imported IArchive:\n");
                    for (IPath path : missingFromImport) {
                        buffer.append(path + "\n");
                    }
                }
                String str = buffer.toString();
                System.err.println(str);
                Assert.fail((String)str);
            }
        }
        catch (Throwable throwable) {
            if (importedArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(importedArchive);
            }
            if (exportedArchive != null) {
                JavaEEArchiveUtilities.INSTANCE.closeArchive(exportedArchive);
            }
            File f = new File(exportDestination);
            f.delete();
            throw throwable;
        }
        if (importedArchive != null) {
            JavaEEArchiveUtilities.INSTANCE.closeArchive(importedArchive);
        }
        if (exportedArchive != null) {
            JavaEEArchiveUtilities.INSTANCE.closeArchive(exportedArchive);
        }
        File f = new File(exportDestination);
        f.delete();
    }

    protected void verifyImportArchiveExists(String archivePath) {
        Assert.assertNotNull((String)"The path to the archive to import can not be null", (Object)archivePath);
        File archive = new File(archivePath);
        Assert.assertTrue((String)("The archive to import, " + archivePath + " does not exist"), (boolean)archive.exists());
    }
}

