/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.web.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public final class WebAppLibrariesContainerTests
extends TestCase {
    private static final String WEBCONTENT_DIR = "WebContent";
    private static final String WEBINF_DIR = "WebContent/WEB-INF";
    private static final String WEBINFLIB_DIR = "WebContent/WEB-INF/lib";
    private static final String ABC_JAR_NAME = "abc.jar";
    private static final String ABC_JAR_PATH = "TestData/WebAppLibrariesContainerTests/abc.jar";
    private static final String FOO_JAR_NAME = "foo.jar";
    private static final String FOO_JAR_PATH = "TestData/WebAppLibrariesContainerTests/foo.jar";
    private static final IProjectFacetVersion UTILITY_FACET = ProjectFacetsManager.getProjectFacet((String)"jst.utility").getVersion("1.0");
    private IProject webProject;
    private IProject utilityProject;
    private IFile jarFile1;
    private IPath jarFile1Path;
    private IFile jarFile2;
    private IPath jarFile2Path;
    private final Set resourcesToCleanup = new HashSet();

    private WebAppLibrariesContainerTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Web App Libraries Container Tests");
        suite.addTest((Test)new WebAppLibrariesContainerTests("testDetectionOfAddedJar"));
        suite.addTest((Test)new WebAppLibrariesContainerTests("testDetectionOfTwoAddedJars"));
        suite.addTest((Test)new WebAppLibrariesContainerTests("testDetectionOfRemovedJar"));
        suite.addTest((Test)new WebAppLibrariesContainerTests("testDetectionOfTwoRemovedJars"));
        return suite;
    }

    public void testDetectionOfAddedJar() throws Exception {
        WebAppLibrariesContainerTests.copyFromPlugin(ABC_JAR_PATH, this.jarFile1);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile1Path));
    }

    public void testDetectionOfTwoAddedJars() throws Exception {
        WebAppLibrariesContainerTests.copyFromPlugin(ABC_JAR_PATH, this.jarFile1);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.copyFromPlugin(FOO_JAR_PATH, this.jarFile2);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile2Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile2Path));
    }

    public void testDetectionOfRemovedJar() throws Exception {
        WebAppLibrariesContainerTests.copyFromPlugin(ABC_JAR_PATH, this.jarFile1);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile1Path));
        this.jarFile1.delete(true, null);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.utilityProject, this.jarFile1Path));
    }

    public void testDetectionOfTwoRemovedJars() throws Exception {
        WebAppLibrariesContainerTests.copyFromPlugin(ABC_JAR_PATH, this.jarFile1);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.copyFromPlugin(FOO_JAR_PATH, this.jarFile2);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile2Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile2Path));
        this.jarFile1.delete(true, null);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.webProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.assertCondition(WebAppLibrariesContainerTests.cpContains(this.webProject, this.jarFile2Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.utilityProject, this.jarFile1Path));
        WebAppLibrariesContainerTests.assertCondition(WebAppLibrariesContainerTests.cpContains(this.utilityProject, this.jarFile2Path));
        this.jarFile2.delete(true, null);
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.webProject, this.jarFile2Path));
        WebAppLibrariesContainerTests.waitForCondition(WebAppLibrariesContainerTests.cpDoesNotContain(this.utilityProject, this.jarFile2Path));
    }

    protected void setUp() throws Exception {
        System.setProperty("wtp.autotest.noninteractive", "true");
        IFacetedProject fpj = ProjectFacetsManager.create((String)"abc", null, null);
        fpj.installProjectFacet(JavaFacetUtils.JAVA_50, null, null);
        fpj.installProjectFacet(WebFacetUtils.WEB_24, null, null);
        this.webProject = fpj.getProject();
        this.jarFile1 = this.webProject.getFile("WebContent/WEB-INF/lib/abc.jar");
        this.jarFile1Path = this.jarFile1.getFullPath();
        this.jarFile2 = this.webProject.getFile("WebContent/WEB-INF/lib/foo.jar");
        this.jarFile2Path = this.jarFile2.getFullPath();
        this.addResourceToCleanup((IResource)this.webProject);
        fpj = ProjectFacetsManager.create((String)"subordinate", null, null);
        fpj.installProjectFacet(JavaFacetUtils.JAVA_50, null, null);
        fpj.installProjectFacet(UTILITY_FACET, null, null);
        IPath path = new Path("org.eclipse.jst.j2ee.internal.web.container").append("abc");
        IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
        WebAppLibrariesContainerTests.addToClasspath(JavaCore.create((IProject)fpj.getProject()), cpe);
        this.utilityProject = fpj.getProject();
        this.addResourceToCleanup((IResource)this.utilityProject);
    }

    protected void tearDown() throws Exception {
        for (IResource r : this.resourcesToCleanup) {
            r.delete(true, null);
        }
    }

    private void addResourceToCleanup(IResource resource) {
        this.resourcesToCleanup.add(resource);
    }

    private static void copyFromPlugin(String src, IFile dest) throws CoreException, IOException {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.jst.j2ee.tests");
        URL entryUrl = bundle.getEntry(src);
        InputStream in = entryUrl.openStream();
        try {
            dest.create(in, true, null);
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    private static void addToClasspath(IJavaProject jproj, IClasspathEntry cpe) throws JavaModelException {
        IClasspathEntry[] oldcp = jproj.getRawClasspath();
        IClasspathEntry[] newcp = new IClasspathEntry[oldcp.length + 1];
        System.arraycopy(oldcp, 0, newcp, 0, oldcp.length);
        newcp[oldcp.length] = cpe;
        jproj.setRawClasspath(newcp, null);
    }

    private static void waitForCondition(ICondition condition) throws Exception {
        WebAppLibrariesContainerTests.waitForCondition(condition, 10);
    }

    private static void waitForCondition(ICondition condition, int seconds) throws Exception {
        int i = 0;
        while (i < seconds && !condition.check()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        WebAppLibrariesContainerTests.assertCondition(condition);
    }

    private static void assertCondition(ICondition condition) throws Exception {
        WebAppLibrariesContainerTests.assertTrue((boolean)condition.check());
    }

    private static ICondition cpContains(IProject project, IPath entry) {
        return new ClasspathContainsCondition(project, entry);
    }

    private static ICondition cpDoesNotContain(IProject project, IPath entry) {
        return new ClasspathDoesNotContainCondition(project, entry);
    }

    private static abstract class AbstractClasspathCondition
    implements ICondition {
        private final IProject project;
        private final IPath entry;

        public AbstractClasspathCondition(IProject project, IPath entry) {
            this.project = project;
            this.entry = entry;
        }

        protected boolean internalCheck() throws Exception {
            IJavaProject jproj = JavaCore.create((IProject)this.project);
            IClasspathEntry[] cp = jproj.getResolvedClasspath(true);
            int i = 0;
            while (i < cp.length) {
                if (cp[i].getPath().equals((Object)this.entry)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static final class ClasspathContainsCondition
    extends AbstractClasspathCondition {
        public ClasspathContainsCondition(IProject project, IPath entry) {
            super(project, entry);
        }

        public boolean check() throws Exception {
            return this.internalCheck();
        }
    }

    private static final class ClasspathDoesNotContainCondition
    extends AbstractClasspathCondition {
        public ClasspathDoesNotContainCondition(IProject project, IPath entry) {
            super(project, entry);
        }

        public boolean check() throws Exception {
            return !this.internalCheck();
        }
    }

    private static interface ICondition {
        public boolean check() throws Exception;
    }
}

