/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.tests.proxy.initParser;

import java.lang.reflect.Array;
import junit.framework.Assert;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringEvaluationException;
import org.eclipse.jem.internal.proxy.initParser.InitializationStringParser;
import org.eclipse.jem.tests.proxy.initParser.AbstractInitStringParserTestHelper;

public class InitStringParserTestHelper
extends AbstractInitStringParserTestHelper {
    private final ClassLoader classLoader;

    public InitStringParserTestHelper() {
        this.classLoader = null;
    }

    public InitStringParserTestHelper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testInitString(String aString, Object expectedResult, boolean throwsException, boolean equalsOnly) throws Throwable {
        try {
            InitializationStringParser parser = InitializationStringParser.createParser((String)aString, (ClassLoader)this.classLoader);
            Object result = parser.evaluate();
            if (throwsException) {
                Assert.fail((String)("It should of thrown an exception. Instead result=" + (result != null ? result.toString() : "null")));
                return;
            }
            if (result == expectedResult) {
                return;
            }
            if (result == null && expectedResult != null || expectedResult == null && result != null) {
                Assert.fail((String)("ExpectedResult=" + expectedResult + " result=" + result));
                return;
            }
            if (result.equals(expectedResult)) {
                return;
            }
            if (result.getClass() != expectedResult.getClass()) {
                Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult + " ActualResult=" + result + " ExpectedClass=" + expectedResult.getClass() + " ActualClass=" + result.getClass()));
                return;
            }
            if (result.toString().equals(expectedResult.toString())) {
                return;
            }
            if (expectedResult.getClass().isArray() && result.getClass().isArray()) {
                Class<?> expectedResultClass = expectedResult.getClass().getComponentType();
                Class<?> resultClass = result.getClass().getComponentType();
                int resultLength = Array.getLength(result);
                int expectedLength = Array.getLength(expectedResult);
                if (expectedLength != resultLength) {
                    Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult + " ActualResult=" + result + " ExpectedClass=" + expectedResult.getClass() + " ActualClass=" + result.getClass()));
                    return;
                }
                if (resultClass == expectedResultClass) {
                    return;
                }
                Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult + " ActualResult=" + result + " ExpectedClass=" + expectedResult.getClass() + " ActualClass=" + result.getClass()));
                return;
            }
            if (!equalsOnly) return;
            Assert.fail((String)(String.valueOf(aString) + " ExpectedResult=" + expectedResult + " ActualResult=" + result + " ExpectedClass=" + expectedResult.getClass() + " ActualClass=" + result.getClass()));
            return;
        }
        catch (InitializationStringEvaluationException e) {
            if (!throwsException) throw e.getOriginalException();
            return;
        }
    }
}

