/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.test.internal.registry;

import org.eclipse.jst.validation.test.internal.registry.MessageUtility;
import org.eclipse.jst.validation.test.internal.registry.ValidatorTestcase;
import org.eclipse.wst.validation.internal.ValidatorMetaData;

public class MessageMetaData {
    public static final int LINENO_UNSET = -1;
    private String _messagePrefix = null;
    private String _resource = null;
    private int _lineNumber = -1;
    private String _location = null;
    private String _text = null;
    private ValidatorTestcase _tmd = null;

    public MessageMetaData(ValidatorTestcase tmd, String prefix, String resource, int lineNumber, String text) {
        this(tmd, prefix, resource, text);
        this._lineNumber = lineNumber;
    }

    public MessageMetaData(ValidatorTestcase tmd, String prefix, String resource, String location, String text) {
        this(tmd, prefix, resource, text);
        this._location = location;
    }

    public MessageMetaData(ValidatorTestcase tmd, String prefix, String resource, String text) {
        this._tmd = tmd;
        this._messagePrefix = prefix;
        this._resource = resource;
        this._text = text == null ? "" : text;
    }

    public ValidatorTestcase getValidatorTestcase() {
        return this._tmd;
    }

    public String getMessagePrefix() {
        return this._messagePrefix;
    }

    public String getResource() {
        return this._resource;
    }

    public int getLineNumber() {
        return this._lineNumber;
    }

    public String getLocation() {
        return this._location;
    }

    public ValidatorMetaData getValidator() {
        return this.getValidatorTestcase().getValidatorMetaData();
    }

    public String getText() {
        return this._text;
    }

    public boolean isSetLineNumber() {
        return this._lineNumber != -1;
    }

    public boolean isSetLocation() {
        return this.isSet(this._location);
    }

    public boolean isSetResource() {
        return this.isSet(this._resource);
    }

    private boolean isSet(String value) {
        if (value == null) {
            return false;
        }
        return !value.trim().equals("");
    }

    public String toString() {
        return MessageUtility.toString(this);
    }
}

