/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.archive.emftests;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;
import org.eclipse.jst.j2ee.archive.emftests.GeneralEMFPopulationTest;
import org.eclipse.jst.j2ee.archive.testutilities.EMFAttributeFeatureGenerator;
import org.eclipse.jst.j2ee.archive.testutilities.J2EEVersionCheck;
import org.eclipse.jst.j2ee.archive.testutilities.TestUtilities;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.core.tests.bvt.AutomatedBVT;
import org.eclipse.wst.common.internal.emf.resource.RendererFactory;
import org.eclipse.wst.common.tests.BaseTestCase;

public class GeneralEMFEditingTest
extends BaseTestCase {
    protected Map equivalentLines;
    public List deferedReferences;
    public static int genDepth = 5;
    public static Object sharedValue;
    public int classIndex = 0;
    public static String[] avClass;
    public static HashSet ignoreAtt;
    public int version;
    public int moduleType;
    public static final int VERSION_1_2 = 0;
    public static final int VERSION_1_3 = 1;
    public static final int VERSION_1_4 = 2;
    public static final int APPICATION = 0;
    public static final int APP_CLIENT = 1;
    public static final int CONNECTOR = 2;
    public static final int EJB = 3;
    public static final int WEB = 4;

    public GeneralEMFEditingTest(String name) {
        super(name);
    }

    public void editRoot(EObject eObject) {
        this.editFeatures(eObject);
    }

    public void editFeatures(EObject eObject) {
        if (eObject == null) {
            return;
        }
        this.editAttributes(eObject);
        this.editReferences(eObject);
    }

    protected void editReferences(EObject eObject) {
        EList references = eObject.eClass().getEAllReferences();
        int i = 0;
        while (i < references.size()) {
            EReference ref = (EReference)references.get(i);
            if (ref.isMany() || eObject.eGet((EStructuralFeature)ref) == null) {
                if (ref.isContainment()) {
                    this.populateContainmentReference(eObject, ref);
                } else {
                    this.populateSharedReference(eObject, ref);
                }
            }
            ++i;
        }
    }

    protected void populateSharedReference(EObject eObject, EReference ref) {
        if (ref.getEType() == JavaRefPackage.eINSTANCE.getJavaClass()) {
            this.setReferenceValue(eObject, ref, this.createJavaClassProxy((EClass)ref.getEType()));
        } else {
            EPackage pkg = ref.getEType().getEPackage();
            if (pkg == eObject.eClass().getEPackage() || pkg == CommonPackage.eINSTANCE) {
                if (eObject.eClass().getName().equals("EAnnotation") || eObject.eClass().getName().equals("EAnnotationImpl") || !J2EEVersionCheck.checkReferenceVersion((EStructuralFeature)ref, this.version, this.moduleType)) {
                    return;
                }
                if (this.deferedReferences == null) {
                    this.deferedReferences = new ArrayList();
                }
                this.deferedReferences.add(new DeferredSharedReferenceAction(eObject, ref));
            }
        }
    }

    protected void populateContainmentReference(EObject eObject, EReference ref) {
        int i = 0;
        while (i < this.getDepthForAttribute(ref)) {
            EObject instance = this.createInstance((EClass)ref.getEType());
            if (instance == null) {
                return;
            }
            if (J2EEVersionCheck.checkReferenceVersion((EStructuralFeature)ref, this.version, this.moduleType)) {
                this.setReferenceValue(eObject, ref, instance);
                if (((InternalEObject)instance).eIsProxy()) {
                    return;
                }
                if (ref.getEType() == eObject.eClass()) {
                    this.editAttributes(instance);
                } else {
                    this.editFeatures(instance);
                }
            }
            ++i;
        }
    }

    protected void setReferenceValue(EObject eObject, EReference ref, Object value) {
        if (ref.getName().equals("EAnnotation") || ref.getName().equals("EAnnotationImpl") || !J2EEVersionCheck.checkReferenceVersion((EStructuralFeature)ref, this.version, this.moduleType)) {
            return;
        }
        if (ref.isMany()) {
            List list = (List)eObject.eGet((EStructuralFeature)ref);
            if (value instanceof Collection) {
                list.addAll((Collection)value);
            } else {
                list.add(value);
            }
        } else {
            eObject.eSet((EStructuralFeature)ref, value);
        }
    }

    public EObject createInstance(EClass eClassifier) {
        if (eClassifier == JavaRefPackage.eINSTANCE.getJavaClass()) {
            return this.createJavaClassProxy(eClassifier);
        }
        return eClassifier.getEPackage().getEFactoryInstance().create(eClassifier);
    }

    protected void editAttributes(EObject eObject) {
        EList attributes = eObject.eClass().getEAllAttributes();
        int i = 0;
        while (i < attributes.size()) {
            EAttribute att = (EAttribute)attributes.get(i);
            if (att.isChangeable() && J2EEVersionCheck.checkAttributeVersion(att, this.version, this.moduleType)) {
                Object value = this.createAttributeValue(att, eObject);
                eObject.eSet((EStructuralFeature)att, value);
            }
            ++i;
        }
    }

    protected Object createAttributeValue(EAttribute att, EObject eObject) {
        if (att.getEType() == JavaRefPackage.eINSTANCE.getJavaClass()) {
            return this.createJavaClassProxy(att.eClass()).getClass();
        }
        return EMFAttributeFeatureGenerator.createAttribute(att, eObject, true, this.version, this.moduleType);
    }

    protected EObject createJavaClassProxy(EClass metaClass) {
        if (avClass == null) {
            avClass = new String[]{"java.util.HashTable", "java.util.List", "java.sql.Data", "java.lang.Integer", "java.lang.String"};
        }
        String name = avClass[this.classIndex];
        ++this.classIndex;
        if (this.classIndex == 5) {
            this.classIndex = 0;
        }
        return JavaClassImpl.createClassRef((String)name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void compareContents(String file1, String file2) throws Exception {
        BufferedReader reader2;
        BufferedReader reader1;
        block12: {
            block10: {
                block11: {
                    reader1 = null;
                    reader2 = null;
                    try {
                        try {
                            int lineno = 1;
                            reader1 = new BufferedReader(new InputStreamReader(this.getFileInputStream(file1)));
                            reader2 = new BufferedReader(new InputStreamReader(this.getFileInputStream(file2)));
                            String line1 = "";
                            String line2 = "";
                            while (true) {
                                block13: {
                                    if (reader1.ready() && reader2.ready()) break block13;
                                }
                                line1 = this.readLineTrimComments(reader1);
                                line2 = this.readLineTrimComments(reader2);
                                if (line1 == null && line2 == null && lineno != 0) {
                                    Object var9_10 = null;
                                    if (reader1 == null) break block10;
                                    break block11;
                                }
                                if (!line1.trim().equals(line2.trim())) {
                                    String message = "Error at line #: " + lineno + '\n' + line1 + '\n' + line2 + '\n';
                                    System.out.println(message);
                                }
                                ++lineno;
                            }
                            GeneralEMFEditingTest.assertTrue((String)("The files have a different number of lines:" + lineno + '\n' + line1 + '\n' + line2 + '\n'), (!reader1.ready() && !reader2.ready() ? 1 : 0) != 0);
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            GeneralEMFEditingTest.assertTrue((String)"IO failed", (boolean)false);
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (reader1 != null) {
                            reader1.close();
                        }
                        if (reader2 == null) throw throwable;
                        reader2.close();
                        throw throwable;
                    }
                }
                reader1.close();
            }
            if (reader2 == null) return;
            reader2.close();
            return;
        }
        Object var9_12 = null;
        if (reader1 != null) {
            reader1.close();
        }
        if (reader2 == null) return;
        reader2.close();
    }

    /*
     * Unable to fully structure code
     */
    private String readLineTrimComments(BufferedReader reader) throws IOException {
        result = reader.readLine();
        if (result.indexOf("<!--") >= 0) ** GOTO lbl8
        return result;
lbl-1000:
        // 1 sources

        {
            if (result.indexOf("-->") >= 0) {
                result = reader.readLine();
                continue;
            }
            return result;
lbl8:
            // 2 sources

            ** while (reader.ready())
        }
lbl9:
        // 1 sources

        return result;
    }

    public void compareContentsIgnoreWhitespace(String file1, String file2, String identifier) throws Exception {
        LineNumberReader reader1 = new LineNumberReader(new InputStreamReader(this.getFileInputStream(file1)));
        LineNumberReader reader2 = new LineNumberReader(new InputStreamReader(this.getFileInputStream(file2)));
        this.compareContentsIgnoreWhitespace(reader1, reader2, identifier);
    }

    public void compareContentsIgnoreWhitespace(LineNumberReader reader1, LineNumberReader reader2, String identifier) throws Exception {
        while (reader1.ready() || reader2.ready()) {
            String line1 = "";
            String line2 = "";
            while (reader1.ready() && line1.equals("")) {
                line1 = reader1.readLine().trim();
            }
            while (reader2.ready() && line2.equals("")) {
                line2 = reader2.readLine().trim();
            }
            if (this.isEquivalentLines(line1, line2)) continue;
            StringBuffer buff = new StringBuffer();
            buff.append("Difference found in test ");
            buff.append(identifier);
            buff.append("\nSource line #: ");
            buff.append(reader1.getLineNumber());
            buff.append('\n');
            buff.append(line1);
            buff.append("\nDestination line #: ");
            buff.append(reader2.getLineNumber());
            buff.append('\n');
            buff.append(line2);
            GeneralEMFEditingTest.assertTrue((String)buff.toString(), (boolean)false);
        }
    }

    public boolean lineEquals(String line1, String line2) {
        return line1.equals(line2);
    }

    public boolean isEquivalentLines(String line1, String line2) {
        if (this.lineEquals(line1, line2)) {
            return true;
        }
        if (this.equalTags(line1, line2)) {
            return true;
        }
        String equiv = (String)this.getEquivalentLines().get(line1);
        return equiv != null && equiv.equals(line2);
    }

    public boolean equalTags(String line1, String line2) {
        int shortEndIndex1 = line1.indexOf("/>");
        int shortEndIndex2 = line2.indexOf("/>");
        if (shortEndIndex1 == -1 && shortEndIndex2 == -1) {
            return false;
        }
        if (shortEndIndex1 != -1) {
            String tagName1 = line1.substring(1, shortEndIndex1);
            String tagName2 = this.extractTagName(line2);
            if (this.checkNoData(line2) && tagName1.equals(tagName2)) {
                return true;
            }
        } else if (shortEndIndex2 != -1) {
            String tagName1 = this.extractTagName(line1);
            String tagName2 = line2.substring(1, shortEndIndex2);
            if (this.checkNoData(line1) && tagName1.equals(tagName2)) {
                return true;
            }
        }
        return false;
    }

    private String extractTagName(String line) {
        int endOpenTag = line.indexOf(">");
        return line.substring(1, endOpenTag);
    }

    private boolean checkNoData(String line) {
        int endOpenTag = line.indexOf(">");
        int startEndTag = line.lastIndexOf("<");
        if (endOpenTag == line.length()) {
            return true;
        }
        return endOpenTag + 1 == startEndTag;
    }

    public Map getEquivalentLines() {
        if (this.equivalentLines == null) {
            this.equivalentLines = new HashMap();
        }
        return this.equivalentLines;
    }

    public void setEquivalentLines(Map equivalentLines) {
        this.equivalentLines = equivalentLines;
    }

    public InputStream getFileInputStream(String path) throws FileNotFoundException {
        return new FileInputStream(path);
    }

    public InputStream getResourceAsStream(String fileName) {
        InputStream in = null;
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        in = loader == null ? ClassLoader.getSystemResourceAsStream(fileName) : loader.getResourceAsStream(fileName);
        GeneralEMFEditingTest.assertTrue((String)("Unable to find resource: " + fileName), (in != null ? 1 : 0) != 0);
        return in;
    }

    public void setGeneralDepth(int depth) {
        GeneralEMFPopulationTest.genDepth = depth;
    }

    public void setModuleType(int type) {
        this.moduleType = type;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getDepthForAttribute(EReference ref) {
        if (ref.isMany()) {
            return genDepth;
        }
        return 1;
    }

    public Object getSharedObjectByType(EObject owner, EReference ref) {
        sharedValue = TestUtilities.getObjectByType(owner.eResource(), ref.getEType(), ref.isMany());
        return sharedValue;
    }

    public static void setIgnoreAtt(HashSet set) {
        ignoreAtt = set;
    }

    protected void tearDown() throws Exception {
        try {
            String out = String.valueOf(AutomatedBVT.baseDirectory) + "testOutput/";
            File del = new File(out);
            this.deleteDirectory(del);
            del.delete();
            out = String.valueOf(AutomatedBVT.baseDirectory) + "../testData/testOutput/";
            del = new File(out);
            this.deleteDirectory(del);
            del.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.tearDown();
    }

    protected void deleteDirectory(File directory) throws IOException {
        if (directory.exists()) {
            File[] delFiles = directory.listFiles();
            int i = 0;
            while (i < delFiles.length) {
                if (delFiles[i].isDirectory()) {
                    this.deleteDirectory(delFiles[i]);
                }
                delFiles[i].delete();
                ++i;
            }
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        RendererFactory.getDefaultRendererFactory().setValidating(false);
    }

    protected class DeferredSharedReferenceAction {
        EObject owner;
        EReference ref;

        public DeferredSharedReferenceAction(EObject owner, EReference ref) {
            this.owner = owner;
            this.ref = ref;
        }

        public void performAction() {
            Object value = GeneralEMFEditingTest.this.getSharedObjectByType(this.owner, this.ref);
            GeneralEMFEditingTest.this.setReferenceValue(this.owner, this.ref, value);
        }
    }
}

