/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.metadata.tests.util;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.JavaFacetUtils;
import org.eclipse.jst.jsf.core.JSFVersion;
import org.eclipse.jst.jsf.core.tests.util.JSFFacetedTestEnvironment;
import org.eclipse.jst.jsf.metadata.tests.MetadataTestsPlugin;
import org.eclipse.jst.jsf.test.util.ConfigurableTestCase;
import org.eclipse.jst.jsf.test.util.JDTTestEnvironment;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.ProjectTestEnvironment;
import org.eclipse.jst.jsf.test.util.TestFileResource;
import org.eclipse.jst.jsf.test.util.WebProjectTestEnvironment;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class BaseTestCase
extends ConfigurableTestCase {
    public static final String PROXY_SETTING_HOST = "proxySettings_Host";
    public static final String PROXY_SETTING_PORT = "proxySettings_Port";
    public static final String JSF_FACET_VERSION = "jsfFacetVersion";
    private final JSFVersion _defaultJSFVersion;
    protected WebProjectTestEnvironment _testEnv;
    protected JDTTestEnvironment _jdtTestEnv;
    private MyConfiguration _configuration;

    public BaseTestCase(JSFVersion defaultJSFVersion) {
        this._defaultJSFVersion = defaultJSFVersion;
    }

    public BaseTestCase(String name, JSFVersion defaultJSFVersion) {
        super(name);
        this._defaultJSFVersion = defaultJSFVersion;
    }

    protected void doStandaloneSetup() {
        super.doStandaloneSetup();
        this._configuration = new MyConfiguration("www-proxy.uk.oracle.com", "80", this._defaultJSFVersion);
    }

    protected void doTestSuiteSetup() {
        super.doTestSuiteSetup();
        this._configuration = new MyConfiguration(this._testConfiguration);
    }

    protected void setUp() throws Exception {
        super.setUp();
        JSFTestUtil.setValidationEnabled((boolean)false);
        if (this._configuration.isProxyEnabled()) {
            JSFTestUtil.setInternetProxyPreferences((boolean)true, (String)this._configuration.getProxyHostName(), (String)this._configuration.getProxyPort());
        }
        String webProjVersion = this._configuration.getJsfVersion() == JSFVersion.V1_0 || this._configuration.getJsfVersion() == JSFVersion.V1_1 ? "2.4" : "2.5";
        this._testEnv = new WebProjectTestEnvironment("MetaDataTest_" + ((Object)((Object)this)).getClass().getName() + "_" + this.getName() + "_" + this._configuration.getJsfVersion(), JavaFacetUtils.JAVA_50, ProjectFacetsManager.getProjectFacet((String)"jst.web").getVersion(webProjVersion));
        this._testEnv.createProject(false);
        BaseTestCase.assertNotNull((Object)this._testEnv);
        BaseTestCase.assertNotNull((Object)this._testEnv.getTestProject());
        BaseTestCase.assertTrue((boolean)this._testEnv.getTestProject().isAccessible());
        this.configureJSFEnvironment();
        this._jdtTestEnv = new JDTTestEnvironment((ProjectTestEnvironment)this._testEnv);
        this.configureJDTTestEnvironment(this._jdtTestEnv);
    }

    protected abstract JSFFacetedTestEnvironment configureJSFEnvironment() throws Exception;

    protected void configureJDTTestEnvironment(JDTTestEnvironment jdtTestEnv) throws Exception {
    }

    protected void tearDown() throws Exception {
        this._testEnv.getTestProject().close(null);
    }

    protected void addJavaFile(String file) throws IOException, JavaModelException, CoreException {
        TestFileResource resource = new TestFileResource();
        resource.load(MetadataTestsPlugin.getDefault().getBundle(), "/testfiles/java/" + file + ".java.data");
        this._jdtTestEnv.addSourceFile("src", "com.foo", file, resource.toString());
    }

    private static class MyConfiguration {
        private final String _proxyHostName;
        private final String _proxyPort;
        private final JSFVersion _jsfVersion;

        MyConfiguration(String proxyHostName, String proxyPort, JSFVersion jsfVersion) {
            this._proxyHostName = proxyHostName;
            this._proxyPort = proxyPort;
            this._jsfVersion = jsfVersion;
        }

        MyConfiguration(ConfigurableTestCase.TestConfiguration configuration) {
            this._proxyHostName = (String)configuration.get((Object)BaseTestCase.PROXY_SETTING_HOST);
            this._proxyPort = (String)configuration.get((Object)BaseTestCase.PROXY_SETTING_PORT);
            this._jsfVersion = JSFVersion.valueOfString((String)((String)configuration.get((Object)BaseTestCase.JSF_FACET_VERSION)));
        }

        public boolean isProxyEnabled() {
            return this._proxyHostName != null && this._proxyPort != null;
        }

        public String getProxyHostName() {
            return this._proxyHostName;
        }

        public String getProxyPort() {
            return this._proxyPort;
        }

        public JSFVersion getJsfVersion() {
            return this._jsfVersion;
        }
    }
}

