/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.tests;

import junit.framework.TestCase;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.tests.unittest.WSJUnitConstants;
import org.eclipse.jst.ws.tests.util.JUnitUtils;
import org.eclipse.wst.command.internal.env.context.PersistentResourceContext;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.EclipseEnvironment;
import org.eclipse.wst.command.internal.env.ui.eclipse.EclipseStatusHandler;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;

public abstract class WSWizardTest
extends TestCase
implements WSJUnitConstants {
    protected IEnvironment env_;
    protected IRuntime serverRuntime_;
    protected IServer server_;
    protected IStructuredSelection initialSelection_;
    public String defaultURL_ = "http://localhost:8080/";

    protected void setUp() throws Exception {
        PersistentResourceContext resourceContext = PersistentResourceContext.getInstance();
        EclipseStatusHandler handler = new EclipseStatusHandler();
        EclipseEnvironment environment = new EclipseEnvironment(null, (ResourceContext)resourceContext, (IStatusHandler)handler);
        this.env_ = environment;
        WSWizardTest.assertTrue((this.env_ != null ? 1 : 0) != 0);
        this.server_ = null;
        JUnitUtils.hideActionDialogs();
        this.installServerRuntime();
        this.installServer();
        this.createProjects();
        this.installInputData();
        this.initJ2EEWSRuntimeServerDefaults();
        this.initInitialSelection();
    }

    protected abstract void installServerRuntime() throws Exception;

    public void installInputData(IEnvironment env, IRuntime serverRuntime, IServer server) throws Exception {
        this.env_ = env;
        this.serverRuntime_ = serverRuntime;
        this.server_ = server;
    }

    protected abstract void createProjects() throws Exception;

    protected abstract void installInputData() throws Exception;

    protected abstract void installServer() throws Exception;

    protected abstract void initJ2EEWSRuntimeServerDefaults() throws Exception;

    protected abstract void initInitialSelection() throws Exception;

    protected void tearDown() throws Exception {
        this.stopServer();
        this.deleteServer();
    }

    protected abstract void deleteInputData() throws Exception;

    protected void stopServer() throws Exception {
        if (this.server_ != null && this.server_.getServerState() == 2) {
            this.server_.stop(true);
        }
        WSWizardTest.assertTrue((this.server_.getServerState() == 4 ? 1 : 0) != 0);
    }

    protected void deleteServer() throws Exception {
        if (this.server_ != null) {
            this.server_.delete();
        }
    }

    protected void deleteServerRuntime() throws Exception {
        if (this.serverRuntime_ != null) {
            this.serverRuntime_.delete();
        }
    }

    protected String getDefaultURL(String path, String contextRoot) {
        StringBuffer url = new StringBuffer(this.defaultURL_);
        url.append(contextRoot);
        url.append('/');
        url.append(path);
        return url.toString();
    }
}

