/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.platform;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.internal.IAttributeMapping;
import org.eclipse.jpt.core.internal.ITypeMapping;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.internal.content.orm.XmlPersistentAttribute;
import org.eclipse.jpt.core.internal.platform.BaseContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContext;
import org.eclipse.jpt.core.internal.platform.DefaultsContextWrapper;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.core.internal.platform.JavaAttributeContext;
import org.eclipse.jpt.core.internal.validation.JpaValidationMessages;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlAttributeContext
extends BaseContext {
    private XmlAttributeMapping xmlAttributeMapping;
    private JavaAttributeContext javaAttributeContext;

    protected XmlAttributeContext(IContext parentContext, XmlAttributeMapping xmlAttributeMapping) {
        super(parentContext);
        this.xmlAttributeMapping = xmlAttributeMapping;
    }

    @Override
    protected void initialize() {
    }

    public XmlPersistentAttribute getAttribute() {
        return this.xmlAttributeMapping.getPersistentAttribute();
    }

    @Override
    public void refreshDefaults(DefaultsContext defaultsContext, IProgressMonitor monitor) {
        JavaPersistentAttribute javaPersistentAttribute;
        JavaPersistentType javaPersistentType = this.xmlAttributeMapping.getPersistentType().findJavaPersistentType();
        String name = this.xmlAttributeMapping.getPersistentAttribute().getName();
        if (name != null && javaPersistentType != null && (javaPersistentAttribute = javaPersistentType.attributeNamed(name)) != null) {
            this.javaAttributeContext = (JavaAttributeContext)this.getPlatform().buildJavaAttributeContext(this, javaPersistentAttribute.getMapping());
        }
        this.xmlAttributeMapping.refreshDefaults(defaultsContext);
    }

    protected XmlAttributeMapping attributeMapping() {
        return this.xmlAttributeMapping;
    }

    protected IAttributeMapping javaAttributeMapping() {
        if (this.javaAttributeContext != null) {
            return this.javaAttributeContext.getMapping();
        }
        return null;
    }

    protected boolean embeddableOwned() {
        return this.attributeMapping().typeMapping().getKey() == "embeddable";
    }

    protected boolean entityOwned() {
        return this.attributeMapping().typeMapping().getKey() == "entity";
    }

    public final DefaultsContext wrapDefaultsContext(DefaultsContext defaultsContext) {
        return new DefaultsContextWrapper(defaultsContext){

            public Object getDefault(String key) {
                return XmlAttributeContext.this.getDefault(key, this.getWrappedDefaultsContext());
            }
        };
    }

    protected Object getDefault(String key, DefaultsContext defaultsContext) {
        return defaultsContext.getDefault(key);
    }

    @Override
    public void addToMessages(List<IMessage> messages) {
        super.addToMessages(messages);
        this.addAttributeMessages(messages);
        this.addInvalidMappingMessage(messages);
    }

    protected void addAttributeMessages(List<IMessage> messages) {
        this.addUnspecifiedAttributeMessage(messages);
        this.addUnresolvedAttributeMessage(messages);
        this.addModifierMessages(messages);
    }

    protected void addUnspecifiedAttributeMessage(List<IMessage> messages) {
        XmlPersistentAttribute persistentAttribute = this.xmlAttributeMapping.getPersistentAttribute();
        if (StringTools.stringIsEmpty((String)persistentAttribute.getName())) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNSPECIFIED_NAME", persistentAttribute, persistentAttribute.nameTextRange()));
        }
    }

    protected void addUnresolvedAttributeMessage(List<IMessage> messages) {
        XmlPersistentAttribute persistentAttribute = this.xmlAttributeMapping.getPersistentAttribute();
        if (!StringTools.stringIsEmpty((String)persistentAttribute.getName()) && persistentAttribute.persistentType().findJdtType() != null && persistentAttribute.getAttribute() == null) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{persistentAttribute.getName(), persistentAttribute.persistentType().getClass_()}, persistentAttribute, persistentAttribute.nameTextRange()));
        }
    }

    protected void addModifierMessages(List<IMessage> messages) {
        XmlPersistentAttribute attribute = this.xmlAttributeMapping.getPersistentAttribute();
        if (attribute.getMapping().getKey() != "transient" && attribute.getAttribute() != null && attribute.getAttribute().isField()) {
            int flags;
            try {
                flags = attribute.getAttribute().getJdtMember().getFlags();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            if (Flags.isFinal((int)flags)) {
                messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_FINAL_FIELD", new String[]{attribute.getName()}, attribute, attribute.validationTextRange()));
            }
            if (Flags.isPublic((int)flags)) {
                messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_PUBLIC_FIELD", new String[]{attribute.getName()}, attribute, attribute.validationTextRange()));
            }
        }
    }

    protected void addInvalidMappingMessage(List<IMessage> messages) {
        XmlAttributeMapping attributeMapping = this.attributeMapping();
        ITypeMapping typeMapping = attributeMapping.typeMapping();
        if (!typeMapping.attributeMappingKeyAllowed(attributeMapping.getKey())) {
            messages.add(JpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_INVALID_MAPPING", new String[]{attributeMapping.getPersistentAttribute().getName()}, attributeMapping, attributeMapping.validationTextRange()));
        }
    }
}

