/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.javaee.core.ParamValue;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils11;
import org.eclipse.jst.jsf.core.internal.project.facet.JSFUtils12;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JSFFacetUninstallDelegate
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("", 1);
        }
        try {
            this.removeJSFLibaries(project, fv, monitor);
            this.uninstallJSFReferencesFromWebApp(project, monitor);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void removeJSFLibaries(IProject project, IProjectFacetVersion fv, IProgressMonitor monitor) {
        IJavaProject jproj = JavaCore.create((IProject)project);
        ArrayList<IClasspathEntry> keptEntries = new ArrayList<IClasspathEntry>();
        try {
            IClasspathEntry[] entries = jproj.getRawClasspath();
            keptEntries = new ArrayList();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() == 5 && !entry.getPath().segment(0).equals("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer")) {
                    keptEntries.add(entry);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JSFCorePlugin.log((Exception)((Object)e), "Cannot get classpath entries to remove JSF Libraries for: " + project.getName());
        }
        if (keptEntries.size() > 0) {
            try {
                jproj.setRawClasspath(keptEntries.toArray(new IClasspathEntry[0]), monitor);
            }
            catch (JavaModelException e) {
                JSFCorePlugin.log((Exception)((Object)e), "Exception occured while removing JSF Libraries during JSF Facet uninstall");
            }
        }
        try {
            ClasspathHelper.removeClasspathEntries((IProject)project, (IProjectFacetVersion)fv);
        }
        catch (CoreException e) {
            JSFCorePlugin.log(4, "Unable to remove server supplied implementation from the classpath.", e);
        }
    }

    private void uninstallJSFReferencesFromWebApp(IProject project, IProgressMonitor monitor) {
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        Object webAppObj = provider.getModelObject();
        if (webAppObj != null) {
            if (this.isJavaEEWebApp(webAppObj)) {
                WebApp webApp = (WebApp)webAppObj;
                org.eclipse.jst.javaee.web.Servlet servlet = JSFUtils12.findJSFServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJSFFromJavaEEWebAppOperation(webApp, servlet), new Path("WEB-INF").append("web.xml"));
            } else {
                org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)webAppObj;
                Servlet servlet = JSFUtils11.findJSFServlet(webApp);
                if (servlet == null) {
                    return;
                }
                provider.modify((Runnable)new RemoveJSFFromJ2EEWebAppOperation(webApp, servlet), new Path("WEB-INF").append("web.xml"));
            }
        }
    }

    private boolean isJavaEEWebApp(Object webAppObj) {
        return webAppObj instanceof WebApp;
    }

    class RemoveJSFFromJ2EEWebAppOperation
    implements Runnable {
        private org.eclipse.jst.j2ee.webapplication.WebApp webApp;
        private Servlet servlet;

        RemoveJSFFromJ2EEWebAppOperation(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            this.webApp = webApp;
            this.servlet = servlet;
        }

        public void run() {
            JSFUtils11.removeURLMappings(this.webApp, this.servlet);
            this.removeJSFContextParams(this.webApp, this.servlet);
            this.removeJSFServlet(this.webApp, this.servlet);
        }

        private void removeJSFContextParams(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove((Object)cp);
                break;
            }
        }

        private void removeJSFServlet(org.eclipse.jst.j2ee.webapplication.WebApp webApp, Servlet servlet) {
            webApp.getServlets().remove((Object)servlet);
        }
    }

    class RemoveJSFFromJavaEEWebAppOperation
    implements Runnable {
        private WebApp webApp;
        private org.eclipse.jst.javaee.web.Servlet servlet;

        RemoveJSFFromJavaEEWebAppOperation(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            this.webApp = webApp;
            this.servlet = servlet;
        }

        public void run() {
            JSFUtils12.removeURLMappings(this.webApp, this.servlet);
            this.removeJSFContextParams(this.webApp, this.servlet);
            this.removeJSFServlet(this.webApp, this.servlet);
        }

        private void removeJSFContextParams(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            for (ParamValue cp : webApp.getContextParams()) {
                if (!cp.getParamName().equals("javax.faces.CONFIG_FILES")) continue;
                webApp.getContextParams().remove(cp);
                break;
            }
        }

        private void removeJSFServlet(WebApp webApp, org.eclipse.jst.javaee.web.Servlet servlet) {
            webApp.getServlets().remove(servlet);
        }
    }
}

