/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.tld;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLElementDeclaration;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.contentmodel.CMNodeWrapper;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.w3c.dom.Element;

public final class CMUtil {
    public static String getTagURI(CMElementDeclaration decl) {
        CMDocument doc;
        if (decl instanceof CMNodeWrapper) {
            decl = (CMElementDeclaration)((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration && (doc = ((TLDElementDeclaration)decl).getOwnerDocument()) instanceof TLDDocument) {
            return ((TLDDocument)doc).getUri();
        }
        return null;
    }

    public static boolean isJSP(CMElementDeclaration decl) {
        if (!decl.supports("isJSP")) {
            return false;
        }
        Boolean b = (Boolean)decl.getProperty("isJSP");
        return b;
    }

    public static boolean isHTML(CMElementDeclaration decl) {
        return !CMUtil.isJSP(decl) && decl instanceof HTMLElementDeclaration;
    }

    public static CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)element.getOwnerDocument();
        if (notifier == null) {
            return null;
        }
        ModelQueryAdapter mqa = (ModelQueryAdapter)notifier.getAdapterFor(ModelQueryAdapter.class);
        if (mqa == null) {
            return null;
        }
        return mqa.getModelQuery().getCMElementDeclaration(element);
    }

    public static TLDElementDeclaration getTLDElementDeclaration(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl instanceof CMNodeWrapper) {
            decl = ((CMNodeWrapper)decl).getOriginNode();
        }
        if (decl instanceof TLDElementDeclaration) {
            return (TLDElementDeclaration)decl;
        }
        return null;
    }

    public static CMElementDeclaration getTLDElementDeclaration(String uri, String elementName, IDocument document) {
        TLDCMDocumentManager tldmgr = TaglibController.getTLDCMDocumentManager((IDocument)document);
        if (tldmgr != null) {
            for (TaglibTracker tracker : tldmgr.getTaglibTrackers()) {
                if (!tracker.getURI().equals(uri)) continue;
                return (CMElementDeclaration)tracker.getElements().getNamedItem(String.valueOf(tracker.getPrefix()) + ":" + elementName);
            }
        }
        return null;
    }

    public static String getElementNamespaceURI(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl == null) {
            String uri = element.getNamespaceURI();
            return uri;
        }
        if (CMUtil.isJSP(decl)) {
            return "jsp";
        }
        if (CMUtil.isHTML(decl)) {
            return "html";
        }
        return CMUtil.getTagURI(decl);
    }

    public static boolean canHaveDirectTextChild(Element element) {
        CMElementDeclaration decl = CMUtil.getElementDeclaration(element);
        if (decl == null) {
            return true;
        }
        int contentType = decl.getContentType();
        return contentType != 2 && contentType != 1;
    }

    private CMUtil() {
    }
}

