/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.common.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.common.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.diagnostics.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.BinaryOperator;

abstract class LogicalBinaryOperator
extends BinaryOperator {
    LogicalBinaryOperator(DiagnosticFactory diagnosticFactory) {
        super(diagnosticFactory);
    }

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
        if (!canCoerceFirstArg || !canCoerceSecondArg) {
            return null;
        }
        Boolean firstArgResolvedValue = null;
        if (firstArg instanceof LiteralType) {
            try {
                firstArgResolvedValue = ((LiteralType)firstArg).coerceToBoolean();
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"coercion already checked; this should never be reached");
            }
        }
        Boolean secondArgResolvedValue = null;
        if (secondArg instanceof LiteralType) {
            try {
                secondArgResolvedValue = ((LiteralType)secondArg).coerceToBoolean();
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"coercion already checked; this should never be reached");
            }
        }
        if (firstArgResolvedValue != null && secondArgResolvedValue != null) {
            boolean result = this.doRealOperation(firstArgResolvedValue, secondArgResolvedValue);
            return result ? BooleanLiteralType.TRUE : BooleanLiteralType.FALSE;
        }
        return new ValueType("Z", 2);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        Boolean boolValue;
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
        if (!canCoerceFirstArg) {
            return this._diagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN("first");
        }
        if (!canCoerceSecondArg) {
            return this._diagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN("first");
        }
        if (firstArg instanceof LiteralType) {
            try {
                boolValue = ((LiteralType)firstArg).coerceToBoolean();
                if (boolValue.booleanValue() == this.shortCircuitValue()) {
                    return this._diagnosticFactory.create_BINARY_OP_FIRST_ARGUMENT_SHORT_CIRCUITS(this.shortCircuitValue(), this.readableOperatorName());
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"coercion already checked; this should never be reached");
            }
        }
        if (secondArg instanceof LiteralType) {
            try {
                boolValue = ((LiteralType)secondArg).coerceToBoolean();
                if (boolValue.booleanValue() == this.shortCircuitValue()) {
                    return this._diagnosticFactory.create_BINARY_OP_SECOND_ARGUMENT_ALWAYS_EVAL_SAME(this.shortCircuitValue(), this.readableOperatorName());
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"coercion already checked; this should never be reached");
            }
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected abstract String readableOperatorName();

    protected abstract boolean shortCircuitValue();

    protected abstract boolean doRealOperation(Boolean var1, Boolean var2);
}

