/*******************************************************************************
 * Copyright (c) 2006, 2007 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;

/**
 * Adapt a Java annotation element with a simple-to-use interface.
 */
public interface AnnotationElementAdapter<T> {

	/**
	 * Return the value of the adapter's annotation element.
	 * Return null if the element is not present.
	 * If the compilation unit is available, #getValue(CompilationUnit)
	 * might be more performant.
	 * @see #getValue(org.eclipse.jdt.core.dom.CompilationUnit)
	 */
	T getValue();

	/**
	 * Given the specified compilation unit, return the value of the
	 * adapter's annotation element.
	 * Return null if the element is not present.
	 * @see #getValue()
	 */
	T getValue(CompilationUnit astRoot);

	/**
	 * Set the value of the adapter's annotation element.
	 * Setting the value of the element to null will cause
	 * the element to be removed from its annotation.
	 */
	void setValue(T value);

	/**
	 * Return the expression value of the adapter's annotation element.
	 * Return null if the element is not present.
	 * If the compilation unit is available, #expression(CompilationUnit)
	 * might be more performant.
	 * @see #expression(org.eclipse.jdt.core.dom.CompilationUnit)
	 */
	Expression expression();

	/**
	 * Given the specified compilation unit, return the expression value of the
	 * adapter's annotation element.
	 * Return null if the element is not present.
	 * @see #expression()
	 */
	Expression expression(CompilationUnit astRoot);

	/**
	 * Return the AST node corresponding to the element.
	 * If the element is missing, return the annotation's node.
	 * If the compilation unit is available, #astNode(CompilationUnit)
	 * might be more performant.
	 * @see #astNode(org.eclipse.jdt.core.dom.CompilationUnit)
	 */
	ASTNode astNode();

	/**
	 * Return the AST node corresponding to the element.
	 * If the element is missing, return the annotation's node.
	 * @see #astNode()
	 */
	ASTNode astNode(CompilationUnit astRoot);

}
