/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests.performance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;
import org.eclipse.wst.validation.internal.operations.OneValidatorOperation;
import org.eclipse.wst.ws.internal.plugin.WSPlugin;
import org.eclipse.wst.ws.internal.preferences.PersistentWSISSBPContext;

public class ValidateWSDLProjectTestCase
extends PerformanceTestCase {
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.wsdl.tests.performance.ValidateWSDLProjectTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz, "Test");
    }

    protected void setUp() throws Exception {
        super.setUp();
        WSPlugin wsui = WSPlugin.getInstance();
        PersistentWSISSBPContext wsicontext = wsui.getWSISSBPContext();
        wsicontext.updateWSICompliances("2");
    }

    public void testWSDLProjectValidation() throws Exception {
        File dir;
        String projectDir = System.getProperty("projectDir");
        Assert.assertNotNull((Object)projectDir);
        if (!projectDir.endsWith("/") && !projectDir.endsWith("\\")) {
            projectDir = String.valueOf(projectDir) + "/";
        }
        if ((dir = new File(projectDir)).exists() && dir.isDirectory()) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("WSDLProject");
            project.create(null);
            project.open(null);
            this.copy(dir, (IContainer)project);
            this.joinBackgroundJobs();
            OneValidatorOperation myRunnable = new OneValidatorOperation(project, "org.eclipse.wst.wsdl.validation.internal.eclipse.WSDLDelegatingValidator", true, false);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            this.tagAsSummary("Validate WSDL Project", new Dimension[]{Dimension.ELAPSED_PROCESS, Dimension.WORKING_SET});
            this.startMeasuring();
            workspace.run((IWorkspaceRunnable)myRunnable, null);
            this.stopMeasuring();
            this.commitMeasurements();
            this.assertPerformance();
        } else {
            ValidateWSDLProjectTestCase.fail((String)dir.toString());
        }
    }

    private void copy(File src, IContainer dest) throws CoreException, FileNotFoundException {
        File[] children = src.listFiles();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getName();
            if (children[i].isDirectory()) {
                IFolder folder = dest.getFolder((IPath)new Path(name));
                folder.create(true, true, null);
                this.copy(children[i], (IContainer)folder);
            } else {
                IFile file = dest.getFile((IPath)new Path(name));
                file.create((InputStream)new FileInputStream(children[i]), true, null);
            }
            ++i;
        }
    }

    private void joinBackgroundJobs() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    Platform.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                }
                catch (InterruptedException interruptedException) {}
                long start = System.currentTimeMillis();
                Display display = Display.getDefault();
                while (System.currentTimeMillis() - start < 5000L) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
            }
        });
    }
}

