/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.color.CSSColorManager;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public class BorderColorMeta
extends CSSPropertyMeta {
    private static final String[] _keywords = new String[]{"transparent"};

    public BorderColorMeta() {
        super(false, "transparent");
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        String text = value.getCssText();
        Object result = CSSColorManager.getInstance().getColor(text);
        if (result != null) {
            return result;
        }
        return this.getInitialValue(propertyName, style);
    }

    protected String[] getKeywordValues() {
        return _keywords;
    }

    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        String colorAttr = null;
        if ("hr".equalsIgnoreCase(htmltag)) {
            colorAttr = DOMUtil.getAttributeIgnoreCase(element, "color");
        } else if ("background-color".equalsIgnoreCase(propertyName)) {
            colorAttr = DOMUtil.getAttributeIgnoreCase(element, "bgcolor");
        }
        if (colorAttr != null && colorAttr.trim().length() != 0) {
            colorAttr = colorAttr.trim();
            Object result = CSSColorManager.getInstance().getColor(colorAttr);
            return result;
        }
        return null;
    }
}

