/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.itemcreation.internal;

import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.elementedit.ElementEditFactoryRegistry;
import org.eclipse.jst.pagedesigner.elementedit.IElementEdit;
import org.eclipse.jst.pagedesigner.itemcreation.AbstractTagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.internal.DefaultTagCreator;

public class TagCreationFactory {
    private static TagCreationFactory INSTANCE = null;

    public static synchronized TagCreationFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagCreationFactory();
        }
        return INSTANCE;
    }

    public ITagCreator createTagCreator(TagIdentifier tagId) {
        IElementEdit elementEdit = ElementEditFactoryRegistry.getInstance().createElementEdit(tagId);
        if (elementEdit != null) {
            ITagCreator tagCreator = null;
            try {
                tagCreator = elementEdit.getTagCreator(tagId);
            }
            catch (Exception e) {
                PDPlugin.getLogger(this.getClass()).error("Error.ProblemLoadingTagCreatorFactory", elementEdit.getClass().toString(), (Throwable)e);
            }
            if (tagCreator != null) {
                if (tagCreator instanceof AbstractTagCreator) {
                    return tagCreator;
                }
                PDPlugin.getLogger(this.getClass()).error("Error.ProblemLoadingTagCreatorFactory", "Tag creator must extend AbstractTagCreator", new Throwable());
            }
        }
        return new DefaultTagCreator();
    }
}

