/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.model;

import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.tests.internal.ProjectUtility;
import org.eclipse.jpt.core.tests.internal.projects.TestFacetedProject;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class ModelInitializationTests
extends TestCase {
    private IJpaModel jpaModel;

    public ModelInitializationTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ProjectUtility.deleteAllProjects();
        this.jpaModel = JptCorePlugin.getJpaModel();
    }

    protected void tearDown() throws Exception {
        ProjectUtility.deleteAllProjects();
        this.jpaModel = null;
        super.tearDown();
    }

    private TestFacetedProject buildTestProject() throws CoreException {
        TestFacetedProject testProject = new TestFacetedProject(ClassTools.shortClassNameForObject((Object)((Object)this)), true);
        testProject.installFacet("jst.java", "5.0");
        testProject.installFacet("jst.utility", "1.0");
        testProject.createFile((IPath)new Path("src/test.pkg/TestEntity.java"), "package test.pkg; @Entity public class TestEntity {}");
        testProject.createFile((IPath)new Path("src/test.pkg/TestEntity2.java"), "package test.pkg; @Entity public class TestEntity2 {}");
        return testProject;
    }

    public void testBasic() {
        ModelInitializationTests.assertNotNull((Object)this.jpaModel);
    }

    public void testFacetInstallation() throws CoreException {
        TestFacetedProject testProject = this.buildTestProject();
        ModelInitializationTests.assertNull((Object)this.jpaModel.getJpaProject(testProject.getProject()));
        testProject.installFacet("jpt.jpa", "1.0");
        ModelInitializationTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.jpaModel.jpaProjects()));
        IJpaProject jpaProject = this.jpaModel.getJpaProject(testProject.getProject());
        ModelInitializationTests.assertNotNull((Object)jpaProject);
        ModelInitializationTests.assertEquals((int)4, (int)CollectionTools.size((Iterator)jpaProject.jpaFiles()));
        ModelInitializationTests.assertNotNull((Object)jpaProject.getJpaFile(testProject.getProject().getFile((IPath)new Path("src/test.pkg/TestEntity.java"))));
        ModelInitializationTests.assertNotNull((Object)jpaProject.getJpaFile(testProject.getProject().getFile((IPath)new Path("src/test.pkg/TestEntity2.java"))));
    }

    public void testProjectOpening() throws CoreException {
        TestFacetedProject testProject = this.buildTestProject();
        testProject.installFacet("jpt.jpa", "1.0");
        testProject.close();
        ModelInitializationTests.assertTrue((!testProject.getProject().isOpen() ? 1 : 0) != 0);
        testProject.open();
        IJpaProject jpaProject = this.jpaModel.getJpaProject(testProject.getProject());
        ModelInitializationTests.assertNotNull((Object)jpaProject);
        ModelInitializationTests.assertNotNull((Object)jpaProject.getJpaFile(testProject.getProject().getFile((IPath)new Path("src/test.pkg/TestEntity.java"))));
        ModelInitializationTests.assertNotNull((Object)jpaProject.getJpaFile(testProject.getProject().getFile((IPath)new Path("src/test.pkg/TestEntity2.java"))));
    }
}

