/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.tests.internal.platform;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.XmlEntityInternal;
import org.eclipse.jpt.core.internal.content.orm.XmlRootContentNode;
import org.eclipse.jpt.core.internal.content.persistence.JavaClassRef;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceXmlRootContentNode;
import org.eclipse.jpt.core.tests.internal.projects.TestJpaProject;
import org.eclipse.jpt.utility.internal.CollectionTools;

public class BaseJpaPlatformTests
extends TestCase {
    protected TestJpaProject jpaProject;
    protected static final String PROJECT_NAME = "PlatformTestProject";
    protected static final String PACKAGE_NAME = "platform.test";
    protected static final String PERSISTENCE_XML_LOCATION = "src/META-INF/persistence.xml";
    protected static final String ORM_XML_LOCATION = "src/META-INF/orm.xml";

    public BaseJpaPlatformTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.jpaProject = this.buildJpaProject(PROJECT_NAME, false);
    }

    protected TestJpaProject buildJpaProject(String projectName, boolean autoBuild) throws Exception {
        return new TestJpaProject(projectName, autoBuild);
    }

    protected void tearDown() throws Exception {
        this.jpaProject.dispose();
        this.jpaProject = null;
        super.tearDown();
    }

    public void testPersistentTypes() throws CoreException, IOException {
        IFile persistenceXmlIFile = this.jpaProject.getProject().getFile(PERSISTENCE_XML_LOCATION);
        IJpaFile persistenceXmlJpaFile = this.jpaProject.getJpaProject().getJpaFile(persistenceXmlIFile);
        PersistenceXmlRootContentNode persistenceRoot = (PersistenceXmlRootContentNode)persistenceXmlJpaFile.getContent();
        Persistence persistence = persistenceRoot.getPersistence();
        IFile ormXmlIFile = this.jpaProject.getProject().getFile(ORM_XML_LOCATION);
        IJpaFile ormXmlJpaFile = this.jpaProject.getJpaProject().getJpaFile(ormXmlIFile);
        XmlRootContentNode ormRoot = (XmlRootContentNode)ormXmlJpaFile.getContent();
        EntityMappingsInternal entityMappings = ormRoot.getEntityMappings();
        XmlEntityInternal xmlEntity = OrmFactory.eINSTANCE.createXmlEntityInternal();
        xmlEntity.setSpecifiedName("XmlEntity");
        entityMappings.getTypeMappings().add((Object)xmlEntity);
        entityMappings.eResource().save(null);
        BaseJpaPlatformTests.assertEquals((int)1, (int)CollectionTools.size((Iterator)this.jpaProject.getJpaProject().getPlatform().persistentTypes(PROJECT_NAME)));
        this.jpaProject.createType(PACKAGE_NAME, "JavaEntity.java", "@Entity public class JavaEntity {}");
        JavaClassRef javaClassRef = PersistenceFactory.eINSTANCE.createJavaClassRef();
        javaClassRef.setJavaClass("platform.test.JavaEntity");
        ((PersistenceUnit)persistence.getPersistenceUnits().get(0)).getClasses().add((Object)javaClassRef);
        persistence.eResource().save(null);
        BaseJpaPlatformTests.assertEquals((int)2, (int)CollectionTools.size((Iterator)this.jpaProject.getJpaProject().getPlatform().persistentTypes(PROJECT_NAME)));
    }
}

