/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.IntAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.NumberStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.mappings.IGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaGenerator
extends JavaEObject
implements IGenerator {
    private final Member member;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final IntAnnotationElementAdapter initialValueAdapter;
    private final IntAnnotationElementAdapter allocationSizeAdapter;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final int INITIAL_VALUE_EDEFAULT = 0;
    protected static final int SPECIFIED_INITIAL_VALUE_EDEFAULT = -1;
    protected int specifiedInitialValue = -1;
    protected static final int DEFAULT_INITIAL_VALUE_EDEFAULT = 0;
    protected int defaultInitialValue = 0;
    protected static final int ALLOCATION_SIZE_EDEFAULT = 0;
    protected static final int SPECIFIED_ALLOCATION_SIZE_EDEFAULT = -1;
    protected int specifiedAllocationSize = -1;
    protected static final int DEFAULT_ALLOCATION_SIZE_EDEFAULT = 0;
    protected int defaultAllocationSize = 0;

    protected JavaGenerator() {
        throw new UnsupportedOperationException("Use JavaGenerator(Member) instead");
    }

    protected JavaGenerator(Member member) {
        this.member = member;
        this.nameAdapter = this.buildAdapter(this.nameAdapter());
        this.initialValueAdapter = this.buildIntAdapter(this.initialValueAdapter());
        this.allocationSizeAdapter = this.buildIntAdapter(this.allocationSizeAdapter());
    }

    protected Member getMember() {
        return this.member;
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IGenerator.class)) {
            case 5: {
                this.allocationSizeAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 2: {
                this.initialValueAdapter.setValue(notification.getNewIntValue());
                break;
            }
            case 0: {
                this.nameAdapter.setValue((String)notification.getNewValue());
                break;
            }
        }
    }

    protected AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    protected IntAnnotationElementAdapter buildIntAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new IntAnnotationElementAdapter(this.buildAdapter(daea));
    }

    protected abstract DeclarationAnnotationAdapter annotationAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> nameAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> initialValueAdapter();

    protected abstract DeclarationAnnotationElementAdapter<String> allocationSizeAdapter();

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_GENERATOR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public int getInitialValue() {
        return this.getSpecifiedInitialValue() == -1 ? this.getDefaultInitialValue() : this.getSpecifiedInitialValue();
    }

    @Override
    public int getSpecifiedInitialValue() {
        return this.specifiedInitialValue;
    }

    @Override
    public void setSpecifiedInitialValue(int newSpecifiedInitialValue) {
        int oldSpecifiedInitialValue = this.specifiedInitialValue;
        this.specifiedInitialValue = newSpecifiedInitialValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, oldSpecifiedInitialValue, this.specifiedInitialValue));
        }
    }

    @Override
    public int getDefaultInitialValue() {
        return this.defaultInitialValue;
    }

    @Override
    public int getAllocationSize() {
        return this.getSpecifiedAllocationSize() == -1 ? this.getDefaultAllocationSize() : this.getSpecifiedAllocationSize();
    }

    @Override
    public int getSpecifiedAllocationSize() {
        return this.specifiedAllocationSize;
    }

    @Override
    public void setSpecifiedAllocationSize(int newSpecifiedAllocationSize) {
        int oldSpecifiedAllocationSize = this.specifiedAllocationSize;
        this.specifiedAllocationSize = newSpecifiedAllocationSize;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldSpecifiedAllocationSize, this.specifiedAllocationSize));
        }
    }

    @Override
    public int getDefaultAllocationSize() {
        return this.defaultAllocationSize;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return new Integer(this.getInitialValue());
            }
            case 2: {
                return new Integer(this.getSpecifiedInitialValue());
            }
            case 3: {
                return new Integer(this.getDefaultInitialValue());
            }
            case 4: {
                return new Integer(this.getAllocationSize());
            }
            case 5: {
                return new Integer(this.getSpecifiedAllocationSize());
            }
            case 6: {
                return new Integer(this.getDefaultAllocationSize());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setSpecifiedInitialValue((Integer)newValue);
                return;
            }
            case 5: {
                this.setSpecifiedAllocationSize((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setSpecifiedInitialValue(-1);
                return;
            }
            case 5: {
                this.setSpecifiedAllocationSize(-1);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.getInitialValue() != 0;
            }
            case 2: {
                return this.specifiedInitialValue != -1;
            }
            case 3: {
                return this.defaultInitialValue != 0;
            }
            case 4: {
                return this.getAllocationSize() != 0;
            }
            case 5: {
                return this.specifiedAllocationSize != -1;
            }
            case 6: {
                return this.defaultAllocationSize != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IGenerator.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IGenerator.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", specifiedInitialValue: ");
        result.append(this.specifiedInitialValue);
        result.append(", defaultInitialValue: ");
        result.append(this.defaultInitialValue);
        result.append(", specifiedAllocationSize: ");
        result.append(this.specifiedAllocationSize);
        result.append(", defaultAllocationSize: ");
        result.append(this.defaultAllocationSize);
        result.append(')');
        return result.toString();
    }

    @Override
    public ITextRange validationTextRange() {
        return this.member.annotationTextRange(this.annotationAdapter());
    }

    public void updateFromJava(CompilationUnit astRoot) {
        this.setName(this.nameAdapter.getValue(astRoot));
        this.setSpecifiedInitialValue(this.initialValueAdapter.getValue(astRoot));
        this.setSpecifiedAllocationSize(this.allocationSizeAdapter.getValue(astRoot));
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(annotationAdapter, elementName);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildNumberAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, NumberStringExpressionConverter.instance());
    }
}

