/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.core.internal.content.java.JavaEObject;
import org.eclipse.jpt.core.internal.content.java.mappings.IntAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.BooleanStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.jdtutility.NumberStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.mappings.INamedColumn;
import org.eclipse.jpt.db.internal.Column;
import org.eclipse.jpt.db.internal.Table;
import org.eclipse.jpt.utility.internal.Filter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaNamedColumn
extends JavaEObject
implements INamedColumn {
    protected static final String NAME_EDEFAULT = null;
    protected static final String SPECIFIED_NAME_EDEFAULT = null;
    protected String specifiedName = SPECIFIED_NAME_EDEFAULT;
    protected static final String DEFAULT_NAME_EDEFAULT = null;
    protected String defaultName = DEFAULT_NAME_EDEFAULT;
    protected static final String COLUMN_DEFINITION_EDEFAULT = null;
    protected String columnDefinition = COLUMN_DEFINITION_EDEFAULT;
    private final INamedColumn.Owner owner;
    private final Member member;
    private final DeclarationAnnotationAdapter daa;
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private final AnnotationElementAdapter<String> columnDefinitionAdapter;

    protected JavaNamedColumn() {
        throw new UnsupportedOperationException("Use JavaNamedColumn(Owner, Member, DeclarationAnnotationAdapter) instead");
    }

    protected JavaNamedColumn(INamedColumn.Owner owner, Member member, DeclarationAnnotationAdapter daa) {
        this.owner = owner;
        this.member = member;
        this.daa = daa;
        this.nameDeclarationAdapter = this.buildStringElementAdapter(this.nameElementName());
        this.nameAdapter = this.buildShortCircuitElementAdapter(this.nameDeclarationAdapter);
        this.columnDefinitionAdapter = this.buildShortCircuitStringElementAdapter(this.columnDefinitionElementName());
    }

    protected DeclarationAnnotationElementAdapter<String> buildStringElementAdapter(String elementName) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(this.daa, elementName);
    }

    protected DeclarationAnnotationElementAdapter<String> buildBooleanElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(this.daa, elementName, BooleanStringExpressionConverter.instance());
    }

    protected DeclarationAnnotationElementAdapter<String> buildIntElementAdapter(String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(this.daa, elementName, NumberStringExpressionConverter.instance());
    }

    protected AnnotationElementAdapter<String> buildShortCircuitElementAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new ShortCircuitAnnotationElementAdapter<String>(this.member, daea);
    }

    protected AnnotationElementAdapter<String> buildShortCircuitStringElementAdapter(String elementName) {
        return this.buildShortCircuitElementAdapter(this.buildStringElementAdapter(elementName));
    }

    protected AnnotationElementAdapter<String> buildShortCircuitBooleanElementAdapter(String elementName) {
        return this.buildShortCircuitElementAdapter(this.buildBooleanElementAdapter(elementName));
    }

    protected IntAnnotationElementAdapter buildShortCircuitIntElementAdapter(String elementName) {
        return new IntAnnotationElementAdapter(this.buildShortCircuitElementAdapter(this.buildIntElementAdapter(elementName)));
    }

    protected abstract String nameElementName();

    protected abstract String columnDefinitionElementName();

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(INamedColumn.class)) {
            case 1: {
                this.nameAdapter.setValue((String)notification.getNewValue());
                break;
            }
            case 3: {
                this.columnDefinitionAdapter.setValue((String)notification.getNewValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_NAMED_COLUMN;
    }

    @Override
    public String getName() {
        return this.getSpecifiedName() == null ? this.getDefaultName() : this.getSpecifiedName();
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String newSpecifiedName) {
        String oldSpecifiedName = this.specifiedName;
        this.specifiedName = newSpecifiedName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldSpecifiedName, (Object)this.specifiedName));
        }
    }

    protected void setDefaultName(String newDefaultName) {
        String oldDefaultName = this.defaultName;
        this.defaultName = newDefaultName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDefaultName, (Object)this.defaultName));
        }
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String newColumnDefinition) {
        String oldColumnDefinition = this.columnDefinition;
        this.columnDefinition = newColumnDefinition;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldColumnDefinition, (Object)this.columnDefinition));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getSpecifiedName();
            }
            case 2: {
                return this.getDefaultName();
            }
            case 3: {
                return this.getColumnDefinition();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedName((String)newValue);
                return;
            }
            case 3: {
                this.setColumnDefinition((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setSpecifiedName(SPECIFIED_NAME_EDEFAULT);
                return;
            }
            case 3: {
                this.setColumnDefinition(COLUMN_DEFINITION_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.getName() != null : !NAME_EDEFAULT.equals(this.getName());
            }
            case 1: {
                return SPECIFIED_NAME_EDEFAULT == null ? this.specifiedName != null : !SPECIFIED_NAME_EDEFAULT.equals(this.specifiedName);
            }
            case 2: {
                return DEFAULT_NAME_EDEFAULT == null ? this.defaultName != null : !DEFAULT_NAME_EDEFAULT.equals(this.defaultName);
            }
            case 3: {
                return COLUMN_DEFINITION_EDEFAULT == null ? this.columnDefinition != null : !COLUMN_DEFINITION_EDEFAULT.equals(this.columnDefinition);
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == INamedColumn.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == INamedColumn.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (specifiedName: ");
        result.append(this.specifiedName);
        result.append(", defaultName: ");
        result.append(this.defaultName);
        result.append(", columnDefinition: ");
        result.append(this.columnDefinition);
        result.append(')');
        return result.toString();
    }

    @Override
    public INamedColumn.Owner getOwner() {
        return this.owner;
    }

    @Override
    public ITextRange validationTextRange() {
        ITextRange textRange = this.member.annotationTextRange(this.daa);
        return textRange != null ? textRange : this.owner.validationTextRange();
    }

    protected ITextRange elementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter) {
        return this.elementTextRange(this.member.annotationElementTextRange(elementAdapter));
    }

    protected ITextRange elementTextRange(DeclarationAnnotationElementAdapter<?> elementAdapter, CompilationUnit astRoot) {
        return this.elementTextRange(this.member.annotationElementTextRange(elementAdapter, astRoot));
    }

    @Override
    public ITextRange nameTextRange() {
        return this.elementTextRange(this.nameDeclarationAdapter);
    }

    public ITextRange nameTextRange(CompilationUnit astRoot) {
        return this.elementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    protected boolean elementTouches(DeclarationAnnotationElementAdapter<?> elementAdapter, int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.member.annotationElementTextRange(elementAdapter, astRoot), pos);
    }

    public void updateFromJava(CompilationUnit astRoot) {
        this.setSpecifiedName(this.nameAdapter.getValue(astRoot));
        this.setColumnDefinition(this.columnDefinitionAdapter.getValue(astRoot));
    }

    @Override
    public Column dbColumn() {
        Table table = this.dbTable();
        return table == null ? null : table.columnNamed(this.getName());
    }

    @Override
    public Table dbTable() {
        return this.owner.dbTable(this.tableName());
    }

    protected abstract String tableName();

    @Override
    public boolean isResolved() {
        return this.dbColumn() != null;
    }

    @Override
    public Iterator<String> connectedCandidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedCandidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.nameTouches(pos, astRoot)) {
            return this.quotedCandidateNames(filter);
        }
        return null;
    }

    private Iterator<String> candidateNames() {
        Table dbTable = this.dbTable();
        return dbTable != null ? dbTable.columnNames() : EmptyIterator.instance();
    }

    private Iterator<String> candidateNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateNames(), filter);
    }

    private Iterator<String> quotedCandidateNames(Filter<String> filter) {
        return StringTools.quote(this.candidateNames(filter));
    }
}

