/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.persistence.resource;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;

public class PersistenceArtifactEdit
extends ArtifactEdit {
    public static PersistenceArtifactEdit getArtifactEditForRead(IProject aProject) {
        PersistenceArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new PersistenceArtifactEdit(aProject, true);
        }
        catch (IllegalArgumentException iae) {
            JptCorePlugin.log(iae);
        }
        return artifactEdit;
    }

    public static PersistenceArtifactEdit getArtifactEditForWrite(IProject aProject) {
        PersistenceArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new PersistenceArtifactEdit(aProject, false);
        }
        catch (IllegalArgumentException iae) {
            JptCorePlugin.log(iae);
        }
        return artifactEdit;
    }

    public PersistenceArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly);
    }

    public PersistenceResource getPersistenceResource(IFile file) {
        try {
            PersistenceResource resource = (PersistenceResource)this.getArtifactEditModel().createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString()));
            if (!resource.isLoaded()) {
                resource.load(this.getArtifactEditModel().getResourceSet().getLoadOptions());
            }
            return resource;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        catch (IOException ioe) {
            JptCorePlugin.log(ioe);
            return null;
        }
    }

    public PersistenceResource getPersistenceResource(String fileURI) {
        try {
            return (PersistenceResource)this.getArtifactEditModel().getResource(URI.createURI((String)fileURI));
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public static /* bridge */ /* synthetic */ ArtifactEdit getArtifactEditForRead(IProject iProject) {
        return PersistenceArtifactEdit.getArtifactEditForRead(iProject);
    }

    public static /* bridge */ /* synthetic */ ArtifactEdit getArtifactEditForWrite(IProject iProject) {
        return PersistenceArtifactEdit.getArtifactEditForWrite(iProject);
    }
}

