/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.ITextRange;
import org.eclipse.jpt.utility.internal.StringTools;

public class ASTNodeTextRange
implements ITextRange {
    private final ASTNode astNode;

    public ASTNodeTextRange(ASTNode astNode) {
        this.astNode = astNode;
    }

    public int getOffset() {
        return this.astNode.getStartPosition();
    }

    public int getLength() {
        return this.astNode.getLength();
    }

    public int getLineNumber() {
        return ((CompilationUnit)this.astNode.getRoot()).getLineNumber(this.getOffset());
    }

    public boolean includes(int index) {
        return this.getOffset() <= index && index < this.end();
    }

    public boolean touches(int index) {
        return this.includes(index) || index == this.end();
    }

    private int end() {
        return this.getOffset() + this.getLength();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ITextRange)) {
            return false;
        }
        ITextRange r = (ITextRange)o;
        return r.getOffset() == this.getOffset() && r.getLength() == this.getLength();
    }

    public int hashCode() {
        return this.getOffset() ^ this.getLength();
    }

    public String toString() {
        String start = String.valueOf(this.getOffset());
        String end = String.valueOf(this.getOffset() + this.getLength() - 1);
        return StringTools.buildToStringFor((Object)this, (Object)(String.valueOf(start) + ", " + end));
    }
}

