/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.ArrayList;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class AttributeAnnotationTools {
    public static IField[] persistableFields(IType type) {
        try {
            return AttributeAnnotationTools.persistableFields_(type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static IField[] persistableFields_(IType type) throws JavaModelException {
        ArrayList<IField> persistableFields = new ArrayList<IField>();
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (AttributeAnnotationTools.fieldIsPersistable(field)) {
                persistableFields.add(field);
            }
            ++n2;
        }
        return persistableFields.toArray(new IField[persistableFields.size()]);
    }

    public static boolean fieldIsPersistable(IField field) {
        try {
            return AttributeAnnotationTools.fieldIsPersistable_(field);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean fieldIsPersistable_(IField field) throws JavaModelException {
        int flags = field.getFlags();
        if (Flags.isStatic((int)flags)) {
            return false;
        }
        return !Flags.isTransient((int)flags);
    }

    public static IMethod[] persistablePropertyGetters(IType type) {
        try {
            return AttributeAnnotationTools.persistablePropertyGetters_(type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static IMethod[] persistablePropertyGetters_(IType type) throws JavaModelException {
        ArrayList<IMethod> persistableMethods = new ArrayList<IMethod>();
        IMethod[] iMethodArray = type.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (AttributeAnnotationTools.methodIsPersistablePropertyGetter(method)) {
                persistableMethods.add(method);
            }
            ++n2;
        }
        return persistableMethods.toArray(new IMethod[persistableMethods.size()]);
    }

    public static boolean methodIsPersistablePropertyGetter(IMethod method) {
        try {
            return AttributeAnnotationTools.methodIsPersistablePropertyGetter_(method);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean methodIsPersistablePropertyGetter_(IMethod method) throws JavaModelException {
        IMethod isMethod;
        if (AttributeAnnotationTools.methodHasBadModifiers(method)) {
            return false;
        }
        String returnType = method.getReturnType();
        if (returnType.equals("V")) {
            return false;
        }
        if (method.getNumberOfParameters() != 0) {
            return false;
        }
        String methodName = method.getElementName();
        int beginIndex = 0;
        boolean booleanGetter = false;
        if (methodName.startsWith("is")) {
            if (!returnType.equals("Z")) return false;
            beginIndex = 2;
        } else {
            if (!methodName.startsWith("get")) return false;
            beginIndex = 3;
            if (returnType.equals("Z")) {
                booleanGetter = true;
            }
        }
        String capitalizedAttributeName = method.getElementName().substring(beginIndex);
        if (booleanGetter && (isMethod = method.getDeclaringType().getMethod("is" + capitalizedAttributeName, new String[0])).exists() && isMethod.getReturnType().equals("Z")) {
            return false;
        }
        IMethod setMethod = method.getDeclaringType().getMethod("set" + capitalizedAttributeName, new String[]{returnType});
        if (!setMethod.exists()) {
            return false;
        }
        if (!AttributeAnnotationTools.methodHasBadModifiers(setMethod)) return setMethod.getReturnType().equals("V");
        return false;
    }

    private static boolean methodHasBadModifiers(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return true;
        }
        int flags = method.getFlags();
        if (Flags.isStatic((int)flags)) {
            return true;
        }
        if (Flags.isFinal((int)flags)) {
            return true;
        }
        return !Flags.isPublic((int)flags) && !Flags.isProtected((int)flags);
    }

    public static boolean typeIsPersistable(IType type) {
        try {
            return AttributeAnnotationTools.typeIsPersistable_(type);
        }
        catch (JavaModelException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static boolean typeIsPersistable_(IType type) throws JavaModelException {
        if (type.isInterface()) {
            return false;
        }
        if (type.isAnnotation()) {
            return false;
        }
        if (type.isEnum()) {
            return false;
        }
        if (type.isLocal()) {
            return false;
        }
        if (type.isAnonymous()) {
            return false;
        }
        int flags = type.getFlags();
        return !Flags.isFinal((int)flags);
    }
}

