/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.jdtutility.AbstractExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanStringExpressionConverter
extends AbstractExpressionConverter<String> {
    private static ExpressionConverter<String> INSTANCE;

    public static ExpressionConverter<String> instance() {
        if (INSTANCE == null) {
            INSTANCE = new BooleanStringExpressionConverter();
        }
        return INSTANCE;
    }

    private BooleanStringExpressionConverter() {
    }

    protected BooleanLiteral convertObject(String string, AST ast) {
        return ast.newBooleanLiteral(Boolean.valueOf(string).booleanValue());
    }

    @Override
    protected String convertExpression(Expression expression) {
        Object value = expression.resolveConstantExpressionValue();
        return value instanceof Boolean ? ((Boolean)value).toString() : null;
    }
}

