/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.jdtutility;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationStringArrayExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.JDTTools;
import org.eclipse.jpt.core.internal.jdtutility.ModifiedDeclaration;
import org.eclipse.jpt.core.internal.jdtutility.NameStringExpressionConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumArrayDeclarationAnnotationElementAdapter
implements DeclarationAnnotationElementAdapter<String[]> {
    private final ConversionDeclarationAnnotationElementAdapter<String[]> adapter;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter) {
        this(annotationAdapter, "value");
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        this(annotationAdapter, elementName, true);
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty) {
        this(annotationAdapter, elementName, removeAnnotationWhenEmpty, true);
    }

    public EnumArrayDeclarationAnnotationElementAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName, boolean removeAnnotationWhenEmpty, boolean removeArrayInitializerWhenEmpty) {
        this(new ConversionDeclarationAnnotationElementAdapter<String[]>(annotationAdapter, elementName, removeAnnotationWhenEmpty, EnumArrayDeclarationAnnotationElementAdapter.buildExpressionConverter(removeArrayInitializerWhenEmpty)));
    }

    private static ExpressionConverter<String[]> buildExpressionConverter(boolean removeArrayInitializerWhenEmpty) {
        return new AnnotationStringArrayExpressionConverter(NameStringExpressionConverter.instance(), removeArrayInitializerWhenEmpty);
    }

    protected EnumArrayDeclarationAnnotationElementAdapter(ConversionDeclarationAnnotationElementAdapter<String[]> adapter) {
        this.adapter = adapter;
    }

    @Override
    public String[] getValue(ModifiedDeclaration declaration) {
        return this.resolve(this.adapter.expression(declaration), declaration);
    }

    @Override
    public void setValue(String[] value, ModifiedDeclaration declaration) {
        this.adapter.setValue(this.convertToShortNames(value, declaration), declaration);
    }

    @Override
    public Expression expression(ModifiedDeclaration declaration) {
        return this.adapter.expression(declaration);
    }

    @Override
    public ASTNode astNode(ModifiedDeclaration declaration) {
        return this.adapter.astNode(declaration);
    }

    protected String[] resolve(Expression expression, ModifiedDeclaration declaration) {
        if (expression == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (expression.getNodeType() == 4) {
            return this.resolveArray((ArrayInitializer)expression, declaration);
        }
        return this.resolveSingleElement(expression, declaration);
    }

    protected String[] resolveArray(ArrayInitializer ai, ModifiedDeclaration declaration) {
        List<Expression> expressions = this.expressions(ai);
        int len = expressions.size();
        String[] enums = new String[len];
        int i = len;
        while (i-- > 0) {
            enums[i] = this.resolveEnum(expressions.get(i));
        }
        return enums;
    }

    protected String[] resolveSingleElement(Expression enumExpression, ModifiedDeclaration declaration) {
        return new String[]{this.resolveEnum(enumExpression)};
    }

    protected String resolveEnum(Expression expression) {
        return JDTTools.resolveEnum(expression);
    }

    private List<Expression> expressions(ArrayInitializer arrayInitializer) {
        return arrayInitializer.expressions();
    }

    protected String[] convertToShortNames(String[] enums, ModifiedDeclaration declaration) {
        if (enums == null) {
            return null;
        }
        int len = enums.length;
        String[] shortNames = new String[len];
        int i = len;
        while (i-- > 0) {
            declaration.addStaticImport(enums[i]);
            shortNames[i] = this.shortName(enums[i]);
        }
        return shortNames;
    }

    protected String shortTypeName(String name) {
        return name.substring(0, name.lastIndexOf(46));
    }

    protected String shortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }
}

