/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.mappings;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CascadeType implements Enumerator
{
    ALL(0, "ALL", "All"),
    PERSIST(1, "PERSIST", "Persist"),
    MERGE(2, "MERGE", "Merge"),
    REMOVE(3, "REMOVE", "Remove"),
    REFRESH(4, "REFRESH", "Refresh");

    public static final int ALL_VALUE = 0;
    public static final int PERSIST_VALUE = 1;
    public static final int MERGE_VALUE = 2;
    public static final int REMOVE_VALUE = 3;
    public static final int REFRESH_VALUE = 4;
    private static final CascadeType[] VALUES_ARRAY;
    public static final List<CascadeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CascadeType[]{ALL, PERSIST, MERGE, REMOVE, REFRESH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CascadeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CascadeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CascadeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CascadeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CascadeType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return PERSIST;
            }
            case 2: {
                return MERGE;
            }
            case 3: {
                return REMOVE;
            }
            case 4: {
                return REFRESH;
            }
        }
        return null;
    }

    private CascadeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static CascadeType[] fromJavaAnnotationValue(String[] javaAnnotationValues) {
        if (javaAnnotationValues == null) {
            return new CascadeType[0];
        }
        CascadeType[] cascadeTypes = new CascadeType[javaAnnotationValues.length];
        int i = 0;
        while (i < javaAnnotationValues.length) {
            String javaAnnotationValue = javaAnnotationValues[i];
            if (javaAnnotationValue != null) {
                if (javaAnnotationValue.equals("javax.persistence.CascadeType.ALL")) {
                    cascadeTypes[i] = ALL;
                } else if (javaAnnotationValue.equals("javax.persistence.CascadeType.PERSIST")) {
                    cascadeTypes[i] = PERSIST;
                } else if (javaAnnotationValue.equals("javax.persistence.CascadeType.MERGE")) {
                    cascadeTypes[i] = MERGE;
                } else if (javaAnnotationValue.equals("javax.persistence.CascadeType.REMOVE")) {
                    cascadeTypes[i] = REMOVE;
                } else if (javaAnnotationValue.equals("javax.persistence.CascadeType.REFRESH")) {
                    cascadeTypes[i] = REFRESH;
                }
            }
            ++i;
        }
        return cascadeTypes;
    }

    public static String[] toJavaAnnotationValue(CascadeType[] cascadeTypes) {
        String[] javaAnnotationValues = new String[cascadeTypes.length];
        int i = 0;
        while (i < cascadeTypes.length) {
            CascadeType cascadeType = cascadeTypes[i];
            if (cascadeType == ALL) {
                javaAnnotationValues[i] = "javax.persistence.CascadeType.ALL";
            } else if (cascadeType == PERSIST) {
                javaAnnotationValues[i] = "javax.persistence.CascadeType.PERSIST";
            } else if (cascadeType == MERGE) {
                javaAnnotationValues[i] = "javax.persistence.CascadeType.MERGE";
            } else if (cascadeType == REMOVE) {
                javaAnnotationValues[i] = "javax.persistence.CascadeType.REMOVE";
            } else if (cascadeType == REFRESH) {
                javaAnnotationValues[i] = "javax.persistence.CascadeType.REFRESH";
            }
            ++i;
        }
        return javaAnnotationValues;
    }
}

